/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionBsnDisableSrcMacCheck;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructions;
import org.projectfloodlight.openflow.protocol.ver13.OFInstructionBsnDisableSrcMacCheckVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFInstructionsVer13;

public class OFInstructionBsnDisableSrcMacCheckVer13Test {
    OFInstructions factory;
    static final byte[] INSTRUCTION_BSN_DISABLE_SRC_MAC_CHECK_SERIALIZED = new byte[]{-1, -1, 0, 16, 0, 92, 22, -57, 0, 0, 0, 0, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFInstructionsVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFInstructionBsnDisableSrcMacCheck instructionBsnDisableSrcMacCheck = this.factory.bsnDisableSrcMacCheck();
        ByteBuf bb = Unpooled.buffer();
        instructionBsnDisableSrcMacCheck.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)INSTRUCTION_BSN_DISABLE_SRC_MAC_CHECK_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFInstructionBsnDisableSrcMacCheck instructionBsnDisableSrcMacCheckBuilt = this.factory.bsnDisableSrcMacCheck();
        ByteBuf input = Unpooled.copiedBuffer((byte[])INSTRUCTION_BSN_DISABLE_SRC_MAC_CHECK_SERIALIZED);
        OFInstructionBsnDisableSrcMacCheck instructionBsnDisableSrcMacCheckRead = OFInstructionBsnDisableSrcMacCheckVer13.READER.readFrom(input);
        Assert.assertEquals((long)INSTRUCTION_BSN_DISABLE_SRC_MAC_CHECK_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)instructionBsnDisableSrcMacCheckBuilt, (Object)instructionBsnDisableSrcMacCheckRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])INSTRUCTION_BSN_DISABLE_SRC_MAC_CHECK_SERIALIZED);
        OFInstructionBsnDisableSrcMacCheck instructionBsnDisableSrcMacCheck = OFInstructionBsnDisableSrcMacCheckVer13.READER.readFrom(input);
        Assert.assertEquals((long)INSTRUCTION_BSN_DISABLE_SRC_MAC_CHECK_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        instructionBsnDisableSrcMacCheck.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)INSTRUCTION_BSN_DISABLE_SRC_MAC_CHECK_SERIALIZED));
    }
}

