/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFHello;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFHelloVer13;

public class OFHelloVer13Test {
    OFFactory factory;
    static final byte[] HELLO_SERIALIZED = new byte[]{4, 0, 0, 32, 18, 52, 86, 120, 0, 1, 0, 12, 0, 0, 0, 1, 0, 0, 0, 2, 0, 1, 0, 12, 0, 0, 0, 3, 0, 0, 0, 4};

    @Before
    public void setup() {
        this.factory = OFFactoryVer13.INSTANCE;
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])HELLO_SERIALIZED);
        OFHello hello = OFHelloVer13.READER.readFrom(input);
        Assert.assertEquals((long)HELLO_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        hello.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)HELLO_SERIALIZED));
    }
}

