/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFGroupModify;
import org.projectfloodlight.openflow.protocol.OFGroupType;
import org.projectfloodlight.openflow.protocol.action.OFActions;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFGroupModifyVer13;
import org.projectfloodlight.openflow.types.OFGroup;
import org.projectfloodlight.openflow.types.OFPort;

public class OFGroupModifyVer13Test {
    OFFactory factory;
    static final byte[] GROUP_MODIFY_SERIALIZED = new byte[]{4, 15, 0, 112, 18, 52, 86, 120, 0, 1, 3, 0, 0, 0, 0, 5, 0, 48, 0, 1, 0, 0, 0, 5, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 0, 1, 0, 0, 0, 6, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFGroupModify.Builder builder = this.factory.buildGroupModify();
        OFActions actions = this.factory.actions();
        builder.setXid(305419896L).setGroupType(OFGroupType.FF).setGroup(OFGroup.of((int)5)).setBuckets((List)ImmutableList.of((Object)this.factory.buildBucket().setWeight(1).setWatchPort(OFPort.of((int)5)).setWatchGroup(OFGroup.ANY).setActions((List)ImmutableList.of((Object)actions.output(OFPort.of((int)5), 0), (Object)actions.output(OFPort.of((int)6), 0))).build(), (Object)this.factory.buildBucket().setWeight(1).setWatchPort(OFPort.of((int)6)).setWatchGroup(OFGroup.ANY).setActions((List)ImmutableList.of((Object)actions.output(OFPort.of((int)5), 0), (Object)actions.output(OFPort.of((int)6), 0))).build())).build();
        OFGroupModify groupModify = builder.build();
        ByteBuf bb = Unpooled.buffer();
        groupModify.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)GROUP_MODIFY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFGroupModify.Builder builder = this.factory.buildGroupModify();
        OFActions actions = this.factory.actions();
        builder.setXid(305419896L).setGroupType(OFGroupType.FF).setGroup(OFGroup.of((int)5)).setBuckets((List)ImmutableList.of((Object)this.factory.buildBucket().setWeight(1).setWatchPort(OFPort.of((int)5)).setWatchGroup(OFGroup.ANY).setActions((List)ImmutableList.of((Object)actions.output(OFPort.of((int)5), 0), (Object)actions.output(OFPort.of((int)6), 0))).build(), (Object)this.factory.buildBucket().setWeight(1).setWatchPort(OFPort.of((int)6)).setWatchGroup(OFGroup.ANY).setActions((List)ImmutableList.of((Object)actions.output(OFPort.of((int)5), 0), (Object)actions.output(OFPort.of((int)6), 0))).build())).build();
        OFGroupModify groupModifyBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])GROUP_MODIFY_SERIALIZED);
        OFGroupModify groupModifyRead = OFGroupModifyVer13.READER.readFrom(input);
        Assert.assertEquals((long)GROUP_MODIFY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)groupModifyBuilt, (Object)groupModifyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])GROUP_MODIFY_SERIALIZED);
        OFGroupModify groupModify = OFGroupModifyVer13.READER.readFrom(input);
        Assert.assertEquals((long)GROUP_MODIFY_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        groupModify.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)GROUP_MODIFY_SERIALIZED));
    }
}

