// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver15;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFBsnUnitVer15 implements OFBsnUnit {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnUnitVer15.class);
    // version: 1.5
    final static byte WIRE_VERSION = 6;
    final static int LENGTH = 5;

        private final static long DEFAULT_VALUE = 0x0L;
        private final static Set<OFBsnUnitType> DEFAULT_UNIT = ImmutableSet.<OFBsnUnitType>of();

    // OF message fields
    private final long value;
    private final Set<OFBsnUnitType> unit;
//
    // Immutable default instance
    final static OFBsnUnitVer15 DEFAULT = new OFBsnUnitVer15(
        DEFAULT_VALUE, DEFAULT_UNIT
    );

    // package private constructor - used by readers, builders, and factory
    OFBsnUnitVer15(long value, Set<OFBsnUnitType> unit) {
        if(unit == null) {
            throw new NullPointerException("OFBsnUnitVer15: property unit cannot be null");
        }
        this.value = value;
        this.unit = unit;
    }

    // Accessors for OF message fields
    @Override
    public long getValue() {
        return value;
    }

    @Override
    public Set<OFBsnUnitType> getUnit() {
        return unit;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }



    public OFBsnUnit.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFBsnUnit.Builder {
        final OFBsnUnitVer15 parentMessage;

        // OF message fields
        private boolean valueSet;
        private long value;
        private boolean unitSet;
        private Set<OFBsnUnitType> unit;

        BuilderWithParent(OFBsnUnitVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public long getValue() {
        return value;
    }

    @Override
    public OFBsnUnit.Builder setValue(long value) {
        this.value = value;
        this.valueSet = true;
        return this;
    }
    @Override
    public Set<OFBsnUnitType> getUnit() {
        return unit;
    }

    @Override
    public OFBsnUnit.Builder setUnit(Set<OFBsnUnitType> unit) {
        this.unit = unit;
        this.unitSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }



        @Override
        public OFBsnUnit build() {
                long value = this.valueSet ? this.value : parentMessage.value;
                Set<OFBsnUnitType> unit = this.unitSet ? this.unit : parentMessage.unit;
                if(unit == null)
                    throw new NullPointerException("Property unit must not be null");

                //
                return new OFBsnUnitVer15(
                    value,
                    unit
                );
        }

    }

    static class Builder implements OFBsnUnit.Builder {
        // OF message fields
        private boolean valueSet;
        private long value;
        private boolean unitSet;
        private Set<OFBsnUnitType> unit;

    @Override
    public long getValue() {
        return value;
    }

    @Override
    public OFBsnUnit.Builder setValue(long value) {
        this.value = value;
        this.valueSet = true;
        return this;
    }
    @Override
    public Set<OFBsnUnitType> getUnit() {
        return unit;
    }

    @Override
    public OFBsnUnit.Builder setUnit(Set<OFBsnUnitType> unit) {
        this.unit = unit;
        this.unitSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

//
        @Override
        public OFBsnUnit build() {
            long value = this.valueSet ? this.value : DEFAULT_VALUE;
            Set<OFBsnUnitType> unit = this.unitSet ? this.unit : DEFAULT_UNIT;
            if(unit == null)
                throw new NullPointerException("Property unit must not be null");


            return new OFBsnUnitVer15(
                    value,
                    unit
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFBsnUnit> {
        @Override
        public OFBsnUnit readFrom(ByteBuf bb) throws OFParseError {
            long value = U32.f(bb.readInt());
            Set<OFBsnUnitType> unit = OFBsnUnitTypeSerializerVer15.readFrom(bb);

            OFBsnUnitVer15 bsnUnitVer15 = new OFBsnUnitVer15(
                    value,
                      unit
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", bsnUnitVer15);
            return bsnUnitVer15;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFBsnUnitVer15Funnel FUNNEL = new OFBsnUnitVer15Funnel();
    static class OFBsnUnitVer15Funnel implements Funnel<OFBsnUnitVer15> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFBsnUnitVer15 message, PrimitiveSink sink) {
            sink.putLong(message.value);
            OFBsnUnitTypeSerializerVer15.putTo(message.unit, sink);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFBsnUnitVer15> {
        @Override
        public void write(ByteBuf bb, OFBsnUnitVer15 message) {
            bb.writeInt(U32.t(message.value));
            OFBsnUnitTypeSerializerVer15.writeTo(bb, message.unit);


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnUnitVer15(");
        b.append("value=").append(value);
        b.append(", ");
        b.append("unit=").append(unit);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFBsnUnitVer15 other = (OFBsnUnitVer15) obj;

        if( value != other.value)
            return false;
        if (unit == null) {
            if (other.unit != null)
                return false;
        } else if (!unit.equals(other.unit))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime *  (int) (value ^ (value >>> 32));
        result = prime * result + ((unit == null) ? 0 : unit.hashCode());
        return result;
    }

}
