// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver14;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFPortDescPropBsnDiagVer14 implements OFPortDescPropBsnDiag {
    private static final Logger logger = LoggerFactory.getLogger(OFPortDescPropBsnDiagVer14.class);
    // version: 1.4
    final static byte WIRE_VERSION = 5;
    final static int LENGTH = 38;

        private final static Set<OFBsnModuleEepromRecvSignalType> DEFAULT_LASER_RECEIVER_POWER_TYPE = ImmutableSet.<OFBsnModuleEepromRecvSignalType>of();

    // OF message fields
    private final OFBsnUnit laserBiasCurr;
    private final OFBsnUnit laserOutputPower;
    private final Set<OFBsnModuleEepromRecvSignalType> laserReceiverPowerType;
    private final OFBsnUnit laserReceiverPower;
    private final OFBsnUnit moduleTemp;
    private final OFBsnUnit moduleVoltage;
//

    // package private constructor - used by readers, builders, and factory
    OFPortDescPropBsnDiagVer14(OFBsnUnit laserBiasCurr, OFBsnUnit laserOutputPower, Set<OFBsnModuleEepromRecvSignalType> laserReceiverPowerType, OFBsnUnit laserReceiverPower, OFBsnUnit moduleTemp, OFBsnUnit moduleVoltage) {
        if(laserBiasCurr == null) {
            throw new NullPointerException("OFPortDescPropBsnDiagVer14: property laserBiasCurr cannot be null");
        }
        if(laserOutputPower == null) {
            throw new NullPointerException("OFPortDescPropBsnDiagVer14: property laserOutputPower cannot be null");
        }
        if(laserReceiverPowerType == null) {
            throw new NullPointerException("OFPortDescPropBsnDiagVer14: property laserReceiverPowerType cannot be null");
        }
        if(laserReceiverPower == null) {
            throw new NullPointerException("OFPortDescPropBsnDiagVer14: property laserReceiverPower cannot be null");
        }
        if(moduleTemp == null) {
            throw new NullPointerException("OFPortDescPropBsnDiagVer14: property moduleTemp cannot be null");
        }
        if(moduleVoltage == null) {
            throw new NullPointerException("OFPortDescPropBsnDiagVer14: property moduleVoltage cannot be null");
        }
        this.laserBiasCurr = laserBiasCurr;
        this.laserOutputPower = laserOutputPower;
        this.laserReceiverPowerType = laserReceiverPowerType;
        this.laserReceiverPower = laserReceiverPower;
        this.moduleTemp = moduleTemp;
        this.moduleVoltage = moduleVoltage;
    }

    // Accessors for OF message fields
    @Override
    public int getType() {
        return 0xffff;
    }

    @Override
    public long getExperimenter() {
        return 0x5c16c7L;
    }

    @Override
    public long getExpType() {
        return 0x7L;
    }

    @Override
    public OFBsnUnit getLaserBiasCurr() {
        return laserBiasCurr;
    }

    @Override
    public OFBsnUnit getLaserOutputPower() {
        return laserOutputPower;
    }

    @Override
    public Set<OFBsnModuleEepromRecvSignalType> getLaserReceiverPowerType() {
        return laserReceiverPowerType;
    }

    @Override
    public OFBsnUnit getLaserReceiverPower() {
        return laserReceiverPower;
    }

    @Override
    public OFBsnUnit getModuleTemp() {
        return moduleTemp;
    }

    @Override
    public OFBsnUnit getModuleVoltage() {
        return moduleVoltage;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }



    public OFPortDescPropBsnDiag.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFPortDescPropBsnDiag.Builder {
        final OFPortDescPropBsnDiagVer14 parentMessage;

        // OF message fields
        private boolean laserBiasCurrSet;
        private OFBsnUnit laserBiasCurr;
        private boolean laserOutputPowerSet;
        private OFBsnUnit laserOutputPower;
        private boolean laserReceiverPowerTypeSet;
        private Set<OFBsnModuleEepromRecvSignalType> laserReceiverPowerType;
        private boolean laserReceiverPowerSet;
        private OFBsnUnit laserReceiverPower;
        private boolean moduleTempSet;
        private OFBsnUnit moduleTemp;
        private boolean moduleVoltageSet;
        private OFBsnUnit moduleVoltage;

        BuilderWithParent(OFPortDescPropBsnDiagVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public int getType() {
        return 0xffff;
    }

    @Override
    public long getExperimenter() {
        return 0x5c16c7L;
    }

    @Override
    public long getExpType() {
        return 0x7L;
    }

    @Override
    public OFPortDescPropBsnDiag.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
    }
    @Override
    public OFBsnUnit getLaserBiasCurr() {
        return laserBiasCurr;
    }

    @Override
    public OFPortDescPropBsnDiag.Builder setLaserBiasCurr(OFBsnUnit laserBiasCurr) {
        this.laserBiasCurr = laserBiasCurr;
        this.laserBiasCurrSet = true;
        return this;
    }
    @Override
    public OFBsnUnit getLaserOutputPower() {
        return laserOutputPower;
    }

    @Override
    public OFPortDescPropBsnDiag.Builder setLaserOutputPower(OFBsnUnit laserOutputPower) {
        this.laserOutputPower = laserOutputPower;
        this.laserOutputPowerSet = true;
        return this;
    }
    @Override
    public Set<OFBsnModuleEepromRecvSignalType> getLaserReceiverPowerType() {
        return laserReceiverPowerType;
    }

    @Override
    public OFPortDescPropBsnDiag.Builder setLaserReceiverPowerType(Set<OFBsnModuleEepromRecvSignalType> laserReceiverPowerType) {
        this.laserReceiverPowerType = laserReceiverPowerType;
        this.laserReceiverPowerTypeSet = true;
        return this;
    }
    @Override
    public OFBsnUnit getLaserReceiverPower() {
        return laserReceiverPower;
    }

    @Override
    public OFPortDescPropBsnDiag.Builder setLaserReceiverPower(OFBsnUnit laserReceiverPower) {
        this.laserReceiverPower = laserReceiverPower;
        this.laserReceiverPowerSet = true;
        return this;
    }
    @Override
    public OFBsnUnit getModuleTemp() {
        return moduleTemp;
    }

    @Override
    public OFPortDescPropBsnDiag.Builder setModuleTemp(OFBsnUnit moduleTemp) {
        this.moduleTemp = moduleTemp;
        this.moduleTempSet = true;
        return this;
    }
    @Override
    public OFBsnUnit getModuleVoltage() {
        return moduleVoltage;
    }

    @Override
    public OFPortDescPropBsnDiag.Builder setModuleVoltage(OFBsnUnit moduleVoltage) {
        this.moduleVoltage = moduleVoltage;
        this.moduleVoltageSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }



        @Override
        public OFPortDescPropBsnDiag build() {
                OFBsnUnit laserBiasCurr = this.laserBiasCurrSet ? this.laserBiasCurr : parentMessage.laserBiasCurr;
                if(laserBiasCurr == null)
                    throw new NullPointerException("Property laserBiasCurr must not be null");
                OFBsnUnit laserOutputPower = this.laserOutputPowerSet ? this.laserOutputPower : parentMessage.laserOutputPower;
                if(laserOutputPower == null)
                    throw new NullPointerException("Property laserOutputPower must not be null");
                Set<OFBsnModuleEepromRecvSignalType> laserReceiverPowerType = this.laserReceiverPowerTypeSet ? this.laserReceiverPowerType : parentMessage.laserReceiverPowerType;
                if(laserReceiverPowerType == null)
                    throw new NullPointerException("Property laserReceiverPowerType must not be null");
                OFBsnUnit laserReceiverPower = this.laserReceiverPowerSet ? this.laserReceiverPower : parentMessage.laserReceiverPower;
                if(laserReceiverPower == null)
                    throw new NullPointerException("Property laserReceiverPower must not be null");
                OFBsnUnit moduleTemp = this.moduleTempSet ? this.moduleTemp : parentMessage.moduleTemp;
                if(moduleTemp == null)
                    throw new NullPointerException("Property moduleTemp must not be null");
                OFBsnUnit moduleVoltage = this.moduleVoltageSet ? this.moduleVoltage : parentMessage.moduleVoltage;
                if(moduleVoltage == null)
                    throw new NullPointerException("Property moduleVoltage must not be null");

                //
                return new OFPortDescPropBsnDiagVer14(
                    laserBiasCurr,
                    laserOutputPower,
                    laserReceiverPowerType,
                    laserReceiverPower,
                    moduleTemp,
                    moduleVoltage
                );
        }

    }

    static class Builder implements OFPortDescPropBsnDiag.Builder {
        // OF message fields
        private boolean laserBiasCurrSet;
        private OFBsnUnit laserBiasCurr;
        private boolean laserOutputPowerSet;
        private OFBsnUnit laserOutputPower;
        private boolean laserReceiverPowerTypeSet;
        private Set<OFBsnModuleEepromRecvSignalType> laserReceiverPowerType;
        private boolean laserReceiverPowerSet;
        private OFBsnUnit laserReceiverPower;
        private boolean moduleTempSet;
        private OFBsnUnit moduleTemp;
        private boolean moduleVoltageSet;
        private OFBsnUnit moduleVoltage;

    @Override
    public int getType() {
        return 0xffff;
    }

    @Override
    public long getExperimenter() {
        return 0x5c16c7L;
    }

    @Override
    public long getExpType() {
        return 0x7L;
    }

    @Override
    public OFPortDescPropBsnDiag.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
    }
    @Override
    public OFBsnUnit getLaserBiasCurr() {
        return laserBiasCurr;
    }

    @Override
    public OFPortDescPropBsnDiag.Builder setLaserBiasCurr(OFBsnUnit laserBiasCurr) {
        this.laserBiasCurr = laserBiasCurr;
        this.laserBiasCurrSet = true;
        return this;
    }
    @Override
    public OFBsnUnit getLaserOutputPower() {
        return laserOutputPower;
    }

    @Override
    public OFPortDescPropBsnDiag.Builder setLaserOutputPower(OFBsnUnit laserOutputPower) {
        this.laserOutputPower = laserOutputPower;
        this.laserOutputPowerSet = true;
        return this;
    }
    @Override
    public Set<OFBsnModuleEepromRecvSignalType> getLaserReceiverPowerType() {
        return laserReceiverPowerType;
    }

    @Override
    public OFPortDescPropBsnDiag.Builder setLaserReceiverPowerType(Set<OFBsnModuleEepromRecvSignalType> laserReceiverPowerType) {
        this.laserReceiverPowerType = laserReceiverPowerType;
        this.laserReceiverPowerTypeSet = true;
        return this;
    }
    @Override
    public OFBsnUnit getLaserReceiverPower() {
        return laserReceiverPower;
    }

    @Override
    public OFPortDescPropBsnDiag.Builder setLaserReceiverPower(OFBsnUnit laserReceiverPower) {
        this.laserReceiverPower = laserReceiverPower;
        this.laserReceiverPowerSet = true;
        return this;
    }
    @Override
    public OFBsnUnit getModuleTemp() {
        return moduleTemp;
    }

    @Override
    public OFPortDescPropBsnDiag.Builder setModuleTemp(OFBsnUnit moduleTemp) {
        this.moduleTemp = moduleTemp;
        this.moduleTempSet = true;
        return this;
    }
    @Override
    public OFBsnUnit getModuleVoltage() {
        return moduleVoltage;
    }

    @Override
    public OFPortDescPropBsnDiag.Builder setModuleVoltage(OFBsnUnit moduleVoltage) {
        this.moduleVoltage = moduleVoltage;
        this.moduleVoltageSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

//
        @Override
        public OFPortDescPropBsnDiag build() {
            if(!this.laserBiasCurrSet)
                throw new IllegalStateException("Property laserBiasCurr doesn't have default value -- must be set");
            if(laserBiasCurr == null)
                throw new NullPointerException("Property laserBiasCurr must not be null");
            if(!this.laserOutputPowerSet)
                throw new IllegalStateException("Property laserOutputPower doesn't have default value -- must be set");
            if(laserOutputPower == null)
                throw new NullPointerException("Property laserOutputPower must not be null");
            Set<OFBsnModuleEepromRecvSignalType> laserReceiverPowerType = this.laserReceiverPowerTypeSet ? this.laserReceiverPowerType : DEFAULT_LASER_RECEIVER_POWER_TYPE;
            if(laserReceiverPowerType == null)
                throw new NullPointerException("Property laserReceiverPowerType must not be null");
            if(!this.laserReceiverPowerSet)
                throw new IllegalStateException("Property laserReceiverPower doesn't have default value -- must be set");
            if(laserReceiverPower == null)
                throw new NullPointerException("Property laserReceiverPower must not be null");
            if(!this.moduleTempSet)
                throw new IllegalStateException("Property moduleTemp doesn't have default value -- must be set");
            if(moduleTemp == null)
                throw new NullPointerException("Property moduleTemp must not be null");
            if(!this.moduleVoltageSet)
                throw new IllegalStateException("Property moduleVoltage doesn't have default value -- must be set");
            if(moduleVoltage == null)
                throw new NullPointerException("Property moduleVoltage must not be null");


            return new OFPortDescPropBsnDiagVer14(
                    laserBiasCurr,
                    laserOutputPower,
                    laserReceiverPowerType,
                    laserReceiverPower,
                    moduleTemp,
                    moduleVoltage
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFPortDescPropBsnDiag> {
        @Override
        public OFPortDescPropBsnDiag readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            // fixed value property type == 0xffff
            short type = bb.readShort();
            if(type != (short) 0xffff)
                throw new OFParseError("Wrong type: Expected=0xffff(0xffff), got="+type);
            int length = U16.f(bb.readShort());
            if(length != 38)
                throw new OFParseError("Wrong length: Expected=38(38), got="+length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            // fixed value property experimenter == 0x5c16c7L
            int experimenter = bb.readInt();
            if(experimenter != 0x5c16c7)
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got="+experimenter);
            // fixed value property expType == 0x7L
            int expType = bb.readInt();
            if(expType != 0x7)
                throw new OFParseError("Wrong expType: Expected=0x7L(0x7L), got="+expType);
            OFBsnUnit laserBiasCurr = OFBsnUnitVer14.READER.readFrom(bb);
            OFBsnUnit laserOutputPower = OFBsnUnitVer14.READER.readFrom(bb);
            Set<OFBsnModuleEepromRecvSignalType> laserReceiverPowerType = OFBsnModuleEepromRecvSignalTypeSerializerVer14.readFrom(bb);
            OFBsnUnit laserReceiverPower = OFBsnUnitVer14.READER.readFrom(bb);
            OFBsnUnit moduleTemp = OFBsnUnitVer14.READER.readFrom(bb);
            OFBsnUnit moduleVoltage = OFBsnUnitVer14.READER.readFrom(bb);

            OFPortDescPropBsnDiagVer14 portDescPropBsnDiagVer14 = new OFPortDescPropBsnDiagVer14(
                    laserBiasCurr,
                      laserOutputPower,
                      laserReceiverPowerType,
                      laserReceiverPower,
                      moduleTemp,
                      moduleVoltage
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", portDescPropBsnDiagVer14);
            return portDescPropBsnDiagVer14;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFPortDescPropBsnDiagVer14Funnel FUNNEL = new OFPortDescPropBsnDiagVer14Funnel();
    static class OFPortDescPropBsnDiagVer14Funnel implements Funnel<OFPortDescPropBsnDiagVer14> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFPortDescPropBsnDiagVer14 message, PrimitiveSink sink) {
            // fixed value property type = 0xffff
            sink.putShort((short) 0xffff);
            // fixed value property length = 38
            sink.putShort((short) 0x26);
            // fixed value property experimenter = 0x5c16c7L
            sink.putInt(0x5c16c7);
            // fixed value property expType = 0x7L
            sink.putInt(0x7);
            message.laserBiasCurr.putTo(sink);
            message.laserOutputPower.putTo(sink);
            OFBsnModuleEepromRecvSignalTypeSerializerVer14.putTo(message.laserReceiverPowerType, sink);
            message.laserReceiverPower.putTo(sink);
            message.moduleTemp.putTo(sink);
            message.moduleVoltage.putTo(sink);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFPortDescPropBsnDiagVer14> {
        @Override
        public void write(ByteBuf bb, OFPortDescPropBsnDiagVer14 message) {
            // fixed value property type = 0xffff
            bb.writeShort((short) 0xffff);
            // fixed value property length = 38
            bb.writeShort((short) 0x26);
            // fixed value property experimenter = 0x5c16c7L
            bb.writeInt(0x5c16c7);
            // fixed value property expType = 0x7L
            bb.writeInt(0x7);
            message.laserBiasCurr.writeTo(bb);
            message.laserOutputPower.writeTo(bb);
            OFBsnModuleEepromRecvSignalTypeSerializerVer14.writeTo(bb, message.laserReceiverPowerType);
            message.laserReceiverPower.writeTo(bb);
            message.moduleTemp.writeTo(bb);
            message.moduleVoltage.writeTo(bb);


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFPortDescPropBsnDiagVer14(");
        b.append("laserBiasCurr=").append(laserBiasCurr);
        b.append(", ");
        b.append("laserOutputPower=").append(laserOutputPower);
        b.append(", ");
        b.append("laserReceiverPowerType=").append(laserReceiverPowerType);
        b.append(", ");
        b.append("laserReceiverPower=").append(laserReceiverPower);
        b.append(", ");
        b.append("moduleTemp=").append(moduleTemp);
        b.append(", ");
        b.append("moduleVoltage=").append(moduleVoltage);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFPortDescPropBsnDiagVer14 other = (OFPortDescPropBsnDiagVer14) obj;

        if (laserBiasCurr == null) {
            if (other.laserBiasCurr != null)
                return false;
        } else if (!laserBiasCurr.equals(other.laserBiasCurr))
            return false;
        if (laserOutputPower == null) {
            if (other.laserOutputPower != null)
                return false;
        } else if (!laserOutputPower.equals(other.laserOutputPower))
            return false;
        if (laserReceiverPowerType == null) {
            if (other.laserReceiverPowerType != null)
                return false;
        } else if (!laserReceiverPowerType.equals(other.laserReceiverPowerType))
            return false;
        if (laserReceiverPower == null) {
            if (other.laserReceiverPower != null)
                return false;
        } else if (!laserReceiverPower.equals(other.laserReceiverPower))
            return false;
        if (moduleTemp == null) {
            if (other.moduleTemp != null)
                return false;
        } else if (!moduleTemp.equals(other.moduleTemp))
            return false;
        if (moduleVoltage == null) {
            if (other.moduleVoltage != null)
                return false;
        } else if (!moduleVoltage.equals(other.moduleVoltage))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((laserBiasCurr == null) ? 0 : laserBiasCurr.hashCode());
        result = prime * result + ((laserOutputPower == null) ? 0 : laserOutputPower.hashCode());
        result = prime * result + ((laserReceiverPowerType == null) ? 0 : laserReceiverPowerType.hashCode());
        result = prime * result + ((laserReceiverPower == null) ? 0 : laserReceiverPower.hashCode());
        result = prime * result + ((moduleTemp == null) ? 0 : moduleTemp.hashCode());
        result = prime * result + ((moduleVoltage == null) ? 0 : moduleVoltage.hashCode());
        return result;
    }

}
