// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver14;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFBsnModuleEepromTransceiverVer14 implements OFBsnModuleEepromTransceiver {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnModuleEepromTransceiverVer14.class);
    // version: 1.4
    final static byte WIRE_VERSION = 5;
    final static int LENGTH = 8;

        private final static U64 DEFAULT_CODES = U64.ZERO;

    // OF message fields
    private final U64 codes;
//
    // Immutable default instance
    final static OFBsnModuleEepromTransceiverVer14 DEFAULT = new OFBsnModuleEepromTransceiverVer14(
        DEFAULT_CODES
    );

    // package private constructor - used by readers, builders, and factory
    OFBsnModuleEepromTransceiverVer14(U64 codes) {
        if(codes == null) {
            throw new NullPointerException("OFBsnModuleEepromTransceiverVer14: property codes cannot be null");
        }
        this.codes = codes;
    }

    // Accessors for OF message fields
    @Override
    public U64 getCodes() {
        return codes;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }



    public OFBsnModuleEepromTransceiver.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFBsnModuleEepromTransceiver.Builder {
        final OFBsnModuleEepromTransceiverVer14 parentMessage;

        // OF message fields
        private boolean codesSet;
        private U64 codes;

        BuilderWithParent(OFBsnModuleEepromTransceiverVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public U64 getCodes() {
        return codes;
    }

    @Override
    public OFBsnModuleEepromTransceiver.Builder setCodes(U64 codes) {
        this.codes = codes;
        this.codesSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }



        @Override
        public OFBsnModuleEepromTransceiver build() {
                U64 codes = this.codesSet ? this.codes : parentMessage.codes;
                if(codes == null)
                    throw new NullPointerException("Property codes must not be null");

                //
                return new OFBsnModuleEepromTransceiverVer14(
                    codes
                );
        }

    }

    static class Builder implements OFBsnModuleEepromTransceiver.Builder {
        // OF message fields
        private boolean codesSet;
        private U64 codes;

    @Override
    public U64 getCodes() {
        return codes;
    }

    @Override
    public OFBsnModuleEepromTransceiver.Builder setCodes(U64 codes) {
        this.codes = codes;
        this.codesSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

//
        @Override
        public OFBsnModuleEepromTransceiver build() {
            U64 codes = this.codesSet ? this.codes : DEFAULT_CODES;
            if(codes == null)
                throw new NullPointerException("Property codes must not be null");


            return new OFBsnModuleEepromTransceiverVer14(
                    codes
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFBsnModuleEepromTransceiver> {
        @Override
        public OFBsnModuleEepromTransceiver readFrom(ByteBuf bb) throws OFParseError {
            U64 codes = U64.ofRaw(bb.readLong());

            OFBsnModuleEepromTransceiverVer14 bsnModuleEepromTransceiverVer14 = new OFBsnModuleEepromTransceiverVer14(
                    codes
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", bsnModuleEepromTransceiverVer14);
            return bsnModuleEepromTransceiverVer14;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFBsnModuleEepromTransceiverVer14Funnel FUNNEL = new OFBsnModuleEepromTransceiverVer14Funnel();
    static class OFBsnModuleEepromTransceiverVer14Funnel implements Funnel<OFBsnModuleEepromTransceiverVer14> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFBsnModuleEepromTransceiverVer14 message, PrimitiveSink sink) {
            message.codes.putTo(sink);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFBsnModuleEepromTransceiverVer14> {
        @Override
        public void write(ByteBuf bb, OFBsnModuleEepromTransceiverVer14 message) {
            bb.writeLong(message.codes.getValue());


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnModuleEepromTransceiverVer14(");
        b.append("codes=").append(codes);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFBsnModuleEepromTransceiverVer14 other = (OFBsnModuleEepromTransceiverVer14) obj;

        if (codes == null) {
            if (other.codes != null)
                return false;
        } else if (!codes.equals(other.codes))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((codes == null) ? 0 : codes.hashCode());
        return result;
    }

}
