/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.Shorts;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.types.OFValueType;

public class ICMPv4Code
implements OFValueType<ICMPv4Code> {
    static final int LENGTH = 1;
    static final short MAX_CODE = 255;
    private final short code;
    private static final short NONE_VAL = 0;
    public static final ICMPv4Code NONE = new ICMPv4Code(0);
    public static final ICMPv4Code NO_MASK = new ICMPv4Code(-1);
    public static final ICMPv4Code FULL_MASK = new ICMPv4Code(0);

    private ICMPv4Code(short code) {
        this.code = code;
    }

    public static ICMPv4Code of(short code) {
        if (code == 0) {
            return NONE;
        }
        if (code > 255 || code < 0) {
            throw new IllegalArgumentException("Illegal ICMPv4 code: " + code);
        }
        return new ICMPv4Code(code);
    }

    @Override
    public int getLength() {
        return 1;
    }

    public short getCode() {
        return this.code;
    }

    public void writeByte(ByteBuf c) {
        c.writeByte((int)this.code);
    }

    public static ICMPv4Code readByte(ByteBuf c) {
        return ICMPv4Code.of(c.readUnsignedByte());
    }

    @Override
    public ICMPv4Code applyMask(ICMPv4Code mask) {
        return ICMPv4Code.of((short)(this.code & mask.code));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.code;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ICMPv4Code other = (ICMPv4Code)obj;
        return this.code == other.code;
    }

    @Override
    public int compareTo(ICMPv4Code o) {
        return Shorts.compare((short)this.code, (short)o.code);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putShort(this.code);
    }

    public String toString() {
        return String.valueOf(this.code);
    }
}

