/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.UnsignedInts;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.types.OFValueType;

public class GenTableId
implements OFValueType<GenTableId>,
Comparable<GenTableId> {
    static final int LENGTH = 2;
    private static final int VALIDATION_MASK = 65535;
    private static final int ALL_VAL = 65535;
    private static final int NONE_VAL = 0;
    public static final GenTableId NONE = new GenTableId(0);
    public static final GenTableId ALL = new GenTableId(65535);
    public static final GenTableId ZERO = NONE;
    private final int id;

    private GenTableId(int id) {
        this.id = id;
    }

    public static GenTableId of(int id) {
        switch (id) {
            case 0: {
                return NONE;
            }
            case 65535: {
                return ALL;
            }
        }
        if ((id & 0xFFFF) != id) {
            throw new IllegalArgumentException("Illegal Table id value: " + id);
        }
        return new GenTableId(id);
    }

    public String toString() {
        return "0x" + Integer.toHexString(this.id);
    }

    public int getValue() {
        return this.id;
    }

    @Override
    public int getLength() {
        return 2;
    }

    public void write2Bytes(ByteBuf c) {
        c.writeShort(this.id);
    }

    public static GenTableId read2Bytes(ByteBuf c) throws OFParseError {
        return GenTableId.of(c.readUnsignedShort());
    }

    @Override
    public GenTableId applyMask(GenTableId mask) {
        return GenTableId.of(this.id & mask.id);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GenTableId)) {
            return false;
        }
        GenTableId other = (GenTableId)obj;
        return other.id == this.id;
    }

    public int hashCode() {
        int prime = 13873;
        return this.id * prime;
    }

    @Override
    public int compareTo(GenTableId other) {
        return UnsignedInts.compare((int)this.id, (int)other.id);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putShort((short)((byte)this.id));
    }
}

