/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmConnTrackingIpv6DstMasked;
import org.projectfloodlight.openflow.protocol.ver15.OFOxmConnTrackingIpv6DstVer15;
import org.projectfloodlight.openflow.types.IPv6Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmConnTrackingIpv6DstMaskedVer15
implements OFOxmConnTrackingIpv6DstMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmConnTrackingIpv6DstMaskedVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 36;
    private static final IPv6Address DEFAULT_VALUE = IPv6Address.NONE;
    private static final IPv6Address DEFAULT_VALUE_MASK = IPv6Address.NONE;
    private final IPv6Address value;
    private final IPv6Address mask;
    static final OFOxmConnTrackingIpv6DstMaskedVer15 DEFAULT = new OFOxmConnTrackingIpv6DstMaskedVer15(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmConnTrackingIpv6DstMaskedVer15Funnel FUNNEL = new OFOxmConnTrackingIpv6DstMaskedVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmConnTrackingIpv6DstMaskedVer15(IPv6Address value, IPv6Address mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmConnTrackingIpv6DstMaskedVer15: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmConnTrackingIpv6DstMaskedVer15: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 128800L;
    }

    @Override
    public IPv6Address getValue() {
        return this.value;
    }

    @Override
    public IPv6Address getMask() {
        return this.mask;
    }

    @Override
    public MatchField<IPv6Address> getMatchField() {
        return MatchField.CONN_TRACKING_IPV6_DST;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<IPv6Address> getCanonical() {
        if (IPv6Address.NO_MASK.equals(this.mask)) {
            return new OFOxmConnTrackingIpv6DstVer15(this.value);
        }
        if (IPv6Address.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmConnTrackingIpv6DstMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmConnTrackingIpv6DstMaskedVer15(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmConnTrackingIpv6DstMaskedVer15 other = (OFOxmConnTrackingIpv6DstMaskedVer15)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmConnTrackingIpv6DstMaskedVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmConnTrackingIpv6DstMaskedVer15 message) {
            bb.writeInt(128800);
            message.value.write16Bytes(bb);
            message.mask.write16Bytes(bb);
        }
    }

    static class OFOxmConnTrackingIpv6DstMaskedVer15Funnel
    implements Funnel<OFOxmConnTrackingIpv6DstMaskedVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmConnTrackingIpv6DstMaskedVer15Funnel() {
        }

        public void funnel(OFOxmConnTrackingIpv6DstMaskedVer15 message, PrimitiveSink sink) {
            sink.putInt(128800);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmConnTrackingIpv6DstMasked> {
        Reader() {
        }

        @Override
        public OFOxmConnTrackingIpv6DstMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 128800) {
                throw new OFParseError("Wrong typeLen: Expected=0x1f720L(0x1f720L), got=" + typeLen);
            }
            IPv6Address value = IPv6Address.read16Bytes(bb);
            IPv6Address mask = IPv6Address.read16Bytes(bb);
            OFOxmConnTrackingIpv6DstMaskedVer15 oxmConnTrackingIpv6DstMaskedVer15 = new OFOxmConnTrackingIpv6DstMaskedVer15(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmConnTrackingIpv6DstMaskedVer15);
            }
            return oxmConnTrackingIpv6DstMaskedVer15;
        }
    }

    static class Builder
    implements OFOxmConnTrackingIpv6DstMasked.Builder {
        private boolean valueSet;
        private IPv6Address value;
        private boolean maskSet;
        private IPv6Address mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 128800L;
        }

        @Override
        public IPv6Address getValue() {
            return this.value;
        }

        @Override
        public OFOxmConnTrackingIpv6DstMasked.Builder setValue(IPv6Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public IPv6Address getMask() {
            return this.mask;
        }

        @Override
        public OFOxmConnTrackingIpv6DstMasked.Builder setMask(IPv6Address mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<IPv6Address> getMatchField() {
            return MatchField.CONN_TRACKING_IPV6_DST;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<IPv6Address> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmConnTrackingIpv6DstMasked build() {
            IPv6Address mask;
            IPv6Address value;
            IPv6Address iPv6Address = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            IPv6Address iPv6Address2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmConnTrackingIpv6DstMaskedVer15(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmConnTrackingIpv6DstMasked.Builder {
        final OFOxmConnTrackingIpv6DstMaskedVer15 parentMessage;
        private boolean valueSet;
        private IPv6Address value;
        private boolean maskSet;
        private IPv6Address mask;

        BuilderWithParent(OFOxmConnTrackingIpv6DstMaskedVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 128800L;
        }

        @Override
        public IPv6Address getValue() {
            return this.value;
        }

        @Override
        public OFOxmConnTrackingIpv6DstMasked.Builder setValue(IPv6Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public IPv6Address getMask() {
            return this.mask;
        }

        @Override
        public OFOxmConnTrackingIpv6DstMasked.Builder setMask(IPv6Address mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<IPv6Address> getMatchField() {
            return MatchField.CONN_TRACKING_IPV6_DST;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<IPv6Address> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmConnTrackingIpv6DstMasked build() {
            IPv6Address mask;
            IPv6Address value;
            IPv6Address iPv6Address = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            IPv6Address iPv6Address2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmConnTrackingIpv6DstMaskedVer15(value, mask);
        }
    }
}

