/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnInnerEthDst;
import org.projectfloodlight.openflow.types.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnInnerEthDstVer15
implements OFOxmBsnInnerEthDst {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnInnerEthDstVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 10;
    private static final MacAddress DEFAULT_VALUE = MacAddress.NONE;
    private final MacAddress value;
    static final OFOxmBsnInnerEthDstVer15 DEFAULT = new OFOxmBsnInnerEthDstVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmBsnInnerEthDstVer15Funnel FUNNEL = new OFOxmBsnInnerEthDstVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnInnerEthDstVer15(MacAddress value) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnInnerEthDstVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 207878L;
    }

    @Override
    public MacAddress getValue() {
        return this.value;
    }

    @Override
    public MatchField<MacAddress> getMatchField() {
        return MatchField.BSN_INNER_ETH_DST;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<MacAddress> getCanonical() {
        return this;
    }

    @Override
    public MacAddress getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.5");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmBsnInnerEthDst.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnInnerEthDstVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnInnerEthDstVer15 other = (OFOxmBsnInnerEthDstVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnInnerEthDstVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnInnerEthDstVer15 message) {
            bb.writeInt(207878);
            message.value.write6Bytes(bb);
        }
    }

    static class OFOxmBsnInnerEthDstVer15Funnel
    implements Funnel<OFOxmBsnInnerEthDstVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnInnerEthDstVer15Funnel() {
        }

        public void funnel(OFOxmBsnInnerEthDstVer15 message, PrimitiveSink sink) {
            sink.putInt(207878);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnInnerEthDst> {
        Reader() {
        }

        @Override
        public OFOxmBsnInnerEthDst readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 207878) {
                throw new OFParseError("Wrong typeLen: Expected=0x32c06L(0x32c06L), got=" + typeLen);
            }
            MacAddress value = MacAddress.read6Bytes(bb);
            OFOxmBsnInnerEthDstVer15 oxmBsnInnerEthDstVer15 = new OFOxmBsnInnerEthDstVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnInnerEthDstVer15);
            }
            return oxmBsnInnerEthDstVer15;
        }
    }

    static class Builder
    implements OFOxmBsnInnerEthDst.Builder {
        private boolean valueSet;
        private MacAddress value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 207878L;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnInnerEthDst.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<MacAddress> getMatchField() {
            return MatchField.BSN_INNER_ETH_DST;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<MacAddress> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public MacAddress getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmBsnInnerEthDst build() {
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnInnerEthDstVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnInnerEthDst.Builder {
        final OFOxmBsnInnerEthDstVer15 parentMessage;
        private boolean valueSet;
        private MacAddress value;

        BuilderWithParent(OFOxmBsnInnerEthDstVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 207878L;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnInnerEthDst.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<MacAddress> getMatchField() {
            return MatchField.BSN_INNER_ETH_DST;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<MacAddress> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public MacAddress getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmBsnInnerEthDst build() {
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnInnerEthDstVer15(value);
        }
    }
}

