/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFIpv6ExthdrFlags;

public class OFIpv6ExthdrFlagsSerializerVer15 {
    public static final short NONEXT_VAL = 1;
    public static final short ESP_VAL = 2;
    public static final short AUTH_VAL = 4;
    public static final short DEST_VAL = 8;
    public static final short FRAG_VAL = 16;
    public static final short ROUTER_VAL = 32;
    public static final short HOP_VAL = 64;
    public static final short UNREP_VAL = 128;
    public static final short UNSEQ_VAL = 256;

    public static Set<OFIpv6ExthdrFlags> readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFIpv6ExthdrFlagsSerializerVer15.ofWireValue(bb.readShort());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, Set<OFIpv6ExthdrFlags> set) {
        bb.writeShort((int)OFIpv6ExthdrFlagsSerializerVer15.toWireValue(set));
    }

    public static void putTo(Set<OFIpv6ExthdrFlags> set, PrimitiveSink sink) {
        sink.putShort(OFIpv6ExthdrFlagsSerializerVer15.toWireValue(set));
    }

    public static Set<OFIpv6ExthdrFlags> ofWireValue(short val) {
        EnumSet<OFIpv6ExthdrFlags> set = EnumSet.noneOf(OFIpv6ExthdrFlags.class);
        if ((val & 1) != 0) {
            set.add(OFIpv6ExthdrFlags.NONEXT);
        }
        if ((val & 2) != 0) {
            set.add(OFIpv6ExthdrFlags.ESP);
        }
        if ((val & 4) != 0) {
            set.add(OFIpv6ExthdrFlags.AUTH);
        }
        if ((val & 8) != 0) {
            set.add(OFIpv6ExthdrFlags.DEST);
        }
        if ((val & 0x10) != 0) {
            set.add(OFIpv6ExthdrFlags.FRAG);
        }
        if ((val & 0x20) != 0) {
            set.add(OFIpv6ExthdrFlags.ROUTER);
        }
        if ((val & 0x40) != 0) {
            set.add(OFIpv6ExthdrFlags.HOP);
        }
        if ((val & 0x80) != 0) {
            set.add(OFIpv6ExthdrFlags.UNREP);
        }
        if ((val & 0x100) != 0) {
            set.add(OFIpv6ExthdrFlags.UNSEQ);
        }
        return Collections.unmodifiableSet(set);
    }

    public static short toWireValue(Set<OFIpv6ExthdrFlags> set) {
        short wireValue = 0;
        block11: for (OFIpv6ExthdrFlags e : set) {
            switch (e) {
                case NONEXT: {
                    wireValue = (short)(wireValue | 1);
                    continue block11;
                }
                case ESP: {
                    wireValue = (short)(wireValue | 2);
                    continue block11;
                }
                case AUTH: {
                    wireValue = (short)(wireValue | 4);
                    continue block11;
                }
                case DEST: {
                    wireValue = (short)(wireValue | 8);
                    continue block11;
                }
                case FRAG: {
                    wireValue = (short)(wireValue | 0x10);
                    continue block11;
                }
                case ROUTER: {
                    wireValue = (short)(wireValue | 0x20);
                    continue block11;
                }
                case HOP: {
                    wireValue = (short)(wireValue | 0x40);
                    continue block11;
                }
                case UNREP: {
                    wireValue = (short)(wireValue | 0x80);
                    continue block11;
                }
                case UNSEQ: {
                    wireValue = (short)(wireValue | 0x100);
                    continue block11;
                }
            }
            throw new IllegalArgumentException("Illegal enum value for type OFIpv6ExthdrFlags in version 1.5: " + (Object)((Object)e));
        }
        return wireValue;
    }
}

