/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFExperimenter;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnHeaderVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFNiciraHeaderVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFExperimenterVer15 {
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 16;
    public static final Reader READER = new Reader();

    OFExperimenterVer15() {
    }

    static class Reader
    implements OFMessageReader<OFExperimenter> {
        Reader() {
        }

        @Override
        public OFExperimenter readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 16) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            U32.f(bb.readInt());
            int experimenter = bb.readInt();
            bb.readerIndex(start);
            switch (experimenter) {
                case 6035143: {
                    return OFBsnHeaderVer15.READER.readFrom(bb);
                }
                case 8992: {
                    return OFNiciraHeaderVer15.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator experimenter of class OFExperimenterVer15: " + experimenter);
        }
    }
}

