/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFControllerStatusPropUri;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.OFConnectionIndex;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFControllerStatusPropUriVer15
implements OFControllerStatusPropUri {
    private static final Logger logger = LoggerFactory.getLogger(OFControllerStatusPropUriVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 36;
    private final OFConnectionIndex uri;
    static final Reader READER = new Reader();
    static final OFControllerStatusPropUriVer15Funnel FUNNEL = new OFControllerStatusPropUriVer15Funnel();
    static final Writer WRITER = new Writer();

    OFControllerStatusPropUriVer15(OFConnectionIndex uri) {
        if (uri == null) {
            throw new NullPointerException("OFControllerStatusPropUriVer15: property uri cannot be null");
        }
        this.uri = uri;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public OFConnectionIndex getUri() {
        return this.uri;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFControllerStatusPropUri.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFControllerStatusPropUriVer15(");
        b.append("uri=").append(this.uri);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFControllerStatusPropUriVer15 other = (OFControllerStatusPropUriVer15)obj;
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFControllerStatusPropUriVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFControllerStatusPropUriVer15 message) {
            bb.writeShort(0);
            bb.writeShort(36);
            message.uri.write4Bytes(bb);
        }
    }

    static class OFControllerStatusPropUriVer15Funnel
    implements Funnel<OFControllerStatusPropUriVer15> {
        private static final long serialVersionUID = 1L;

        OFControllerStatusPropUriVer15Funnel() {
        }

        public void funnel(OFControllerStatusPropUriVer15 message, PrimitiveSink sink) {
            sink.putShort((short)0);
            sink.putShort((short)36);
            message.uri.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFControllerStatusPropUri> {
        Reader() {
        }

        @Override
        public OFControllerStatusPropUri readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 0) {
                throw new OFParseError("Wrong type: Expected=0x0(0x0), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 36) {
                throw new OFParseError("Wrong length: Expected=36(36), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFConnectionIndex uri = OFConnectionIndex.read4Bytes(bb);
            OFControllerStatusPropUriVer15 controllerStatusPropUriVer15 = new OFControllerStatusPropUriVer15(uri);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)controllerStatusPropUriVer15);
            }
            return controllerStatusPropUriVer15;
        }
    }

    static class Builder
    implements OFControllerStatusPropUri.Builder {
        private boolean uriSet;
        private OFConnectionIndex uri;

        Builder() {
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public OFConnectionIndex getUri() {
            return this.uri;
        }

        @Override
        public OFControllerStatusPropUri.Builder setUri(OFConnectionIndex uri) {
            this.uri = uri;
            this.uriSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFControllerStatusPropUri build() {
            if (!this.uriSet) {
                throw new IllegalStateException("Property uri doesn't have default value -- must be set");
            }
            if (this.uri == null) {
                throw new NullPointerException("Property uri must not be null");
            }
            return new OFControllerStatusPropUriVer15(this.uri);
        }
    }

    static class BuilderWithParent
    implements OFControllerStatusPropUri.Builder {
        final OFControllerStatusPropUriVer15 parentMessage;
        private boolean uriSet;
        private OFConnectionIndex uri;

        BuilderWithParent(OFControllerStatusPropUriVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public OFConnectionIndex getUri() {
            return this.uri;
        }

        @Override
        public OFControllerStatusPropUri.Builder setUri(OFConnectionIndex uri) {
            this.uri = uri;
            this.uriSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFControllerStatusPropUri build() {
            OFConnectionIndex uri;
            OFConnectionIndex oFConnectionIndex = uri = this.uriSet ? this.uri : this.parentMessage.uri;
            if (uri == null) {
                throw new NullPointerException("Property uri must not be null");
            }
            return new OFControllerStatusPropUriVer15(uri);
        }
    }
}

