/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFCapabilities;

public class OFCapabilitiesSerializerVer15 {
    public static final int FLOW_STATS_VAL = 1;
    public static final int TABLE_STATS_VAL = 2;
    public static final int PORT_STATS_VAL = 4;
    public static final int IP_REASM_VAL = 32;
    public static final int QUEUE_STATS_VAL = 64;
    public static final int GROUP_STATS_VAL = 8;
    public static final int PORT_BLOCKED_VAL = 256;
    public static final int BUNDLES_VAL = 512;
    public static final int FLOW_MONITORING_VAL = 1024;

    public static Set<OFCapabilities> readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFCapabilitiesSerializerVer15.ofWireValue(bb.readInt());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, Set<OFCapabilities> set) {
        bb.writeInt(OFCapabilitiesSerializerVer15.toWireValue(set));
    }

    public static void putTo(Set<OFCapabilities> set, PrimitiveSink sink) {
        sink.putInt(OFCapabilitiesSerializerVer15.toWireValue(set));
    }

    public static Set<OFCapabilities> ofWireValue(int val) {
        EnumSet<OFCapabilities> set = EnumSet.noneOf(OFCapabilities.class);
        if ((val & 1) != 0) {
            set.add(OFCapabilities.FLOW_STATS);
        }
        if ((val & 2) != 0) {
            set.add(OFCapabilities.TABLE_STATS);
        }
        if ((val & 4) != 0) {
            set.add(OFCapabilities.PORT_STATS);
        }
        if ((val & 0x20) != 0) {
            set.add(OFCapabilities.IP_REASM);
        }
        if ((val & 0x40) != 0) {
            set.add(OFCapabilities.QUEUE_STATS);
        }
        if ((val & 8) != 0) {
            set.add(OFCapabilities.GROUP_STATS);
        }
        if ((val & 0x100) != 0) {
            set.add(OFCapabilities.PORT_BLOCKED);
        }
        if ((val & 0x200) != 0) {
            set.add(OFCapabilities.BUNDLES);
        }
        if ((val & 0x400) != 0) {
            set.add(OFCapabilities.FLOW_MONITORING);
        }
        return Collections.unmodifiableSet(set);
    }

    public static int toWireValue(Set<OFCapabilities> set) {
        int wireValue = 0;
        block11: for (OFCapabilities e : set) {
            switch (e) {
                case FLOW_STATS: {
                    wireValue |= 1;
                    continue block11;
                }
                case TABLE_STATS: {
                    wireValue |= 2;
                    continue block11;
                }
                case PORT_STATS: {
                    wireValue |= 4;
                    continue block11;
                }
                case IP_REASM: {
                    wireValue |= 0x20;
                    continue block11;
                }
                case QUEUE_STATS: {
                    wireValue |= 0x40;
                    continue block11;
                }
                case GROUP_STATS: {
                    wireValue |= 8;
                    continue block11;
                }
                case PORT_BLOCKED: {
                    wireValue |= 0x100;
                    continue block11;
                }
                case BUNDLES: {
                    wireValue |= 0x200;
                    continue block11;
                }
                case FLOW_MONITORING: {
                    wireValue |= 0x400;
                    continue block11;
                }
            }
            throw new IllegalArgumentException("Illegal enum value for type OFCapabilities in version 1.5: " + (Object)((Object)e));
        }
        return wireValue;
    }
}

