/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvUsePacketState;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvUsePacketStateVer15
implements OFBsnTlvUsePacketState {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvUsePacketStateVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 5;
    private static final short DEFAULT_VALUE = 0;
    private final short value;
    static final OFBsnTlvUsePacketStateVer15 DEFAULT = new OFBsnTlvUsePacketStateVer15(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvUsePacketStateVer15Funnel FUNNEL = new OFBsnTlvUsePacketStateVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvUsePacketStateVer15(short value) {
        this.value = U8.normalize(value);
    }

    @Override
    public int getType() {
        return 96;
    }

    @Override
    public short getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvUsePacketState.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvUsePacketStateVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvUsePacketStateVer15 other = (OFBsnTlvUsePacketStateVer15)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvUsePacketStateVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvUsePacketStateVer15 message) {
            bb.writeShort(96);
            bb.writeShort(5);
            bb.writeByte((int)U8.t(message.value));
        }
    }

    static class OFBsnTlvUsePacketStateVer15Funnel
    implements Funnel<OFBsnTlvUsePacketStateVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvUsePacketStateVer15Funnel() {
        }

        public void funnel(OFBsnTlvUsePacketStateVer15 message, PrimitiveSink sink) {
            sink.putShort((short)96);
            sink.putShort((short)5);
            sink.putShort(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvUsePacketState> {
        Reader() {
        }

        @Override
        public OFBsnTlvUsePacketState readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 96) {
                throw new OFParseError("Wrong type: Expected=0x60(0x60), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            short value = U8.f(bb.readByte());
            OFBsnTlvUsePacketStateVer15 bsnTlvUsePacketStateVer15 = new OFBsnTlvUsePacketStateVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvUsePacketStateVer15);
            }
            return bsnTlvUsePacketStateVer15;
        }
    }

    static class Builder
    implements OFBsnTlvUsePacketState.Builder {
        private boolean valueSet;
        private short value;

        Builder() {
        }

        @Override
        public int getType() {
            return 96;
        }

        @Override
        public short getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUsePacketState.Builder setValue(short value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvUsePacketState build() {
            short value = this.valueSet ? this.value : (short)0;
            return new OFBsnTlvUsePacketStateVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvUsePacketState.Builder {
        final OFBsnTlvUsePacketStateVer15 parentMessage;
        private boolean valueSet;
        private short value;

        BuilderWithParent(OFBsnTlvUsePacketStateVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 96;
        }

        @Override
        public short getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUsePacketState.Builder setValue(short value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvUsePacketState build() {
            short value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvUsePacketStateVer15(value);
        }
    }
}

