/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnCml;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvSrcMacCml;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnCmlSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvSrcMacCmlVer15
implements OFBsnTlvSrcMacCml {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvSrcMacCmlVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 6;
    private final OFBsnCml value;
    static final Reader READER = new Reader();
    static final OFBsnTlvSrcMacCmlVer15Funnel FUNNEL = new OFBsnTlvSrcMacCmlVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvSrcMacCmlVer15(OFBsnCml value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvSrcMacCmlVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 191;
    }

    @Override
    public OFBsnCml getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvSrcMacCml.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvSrcMacCmlVer15(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvSrcMacCmlVer15 other = (OFBsnTlvSrcMacCmlVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvSrcMacCmlVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvSrcMacCmlVer15 message) {
            bb.writeShort(191);
            bb.writeShort(6);
            OFBsnCmlSerializerVer15.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvSrcMacCmlVer15Funnel
    implements Funnel<OFBsnTlvSrcMacCmlVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvSrcMacCmlVer15Funnel() {
        }

        public void funnel(OFBsnTlvSrcMacCmlVer15 message, PrimitiveSink sink) {
            sink.putShort((short)191);
            sink.putShort((short)6);
            OFBsnCmlSerializerVer15.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvSrcMacCml> {
        Reader() {
        }

        @Override
        public OFBsnTlvSrcMacCml readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 191) {
                throw new OFParseError("Wrong type: Expected=0xbf(0xbf), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnCml value = OFBsnCmlSerializerVer15.readFrom(bb);
            OFBsnTlvSrcMacCmlVer15 bsnTlvSrcMacCmlVer15 = new OFBsnTlvSrcMacCmlVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvSrcMacCmlVer15);
            }
            return bsnTlvSrcMacCmlVer15;
        }
    }

    static class Builder
    implements OFBsnTlvSrcMacCml.Builder {
        private boolean valueSet;
        private OFBsnCml value;

        Builder() {
        }

        @Override
        public int getType() {
            return 191;
        }

        @Override
        public OFBsnCml getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvSrcMacCml.Builder setValue(OFBsnCml value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvSrcMacCml build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvSrcMacCmlVer15(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvSrcMacCml.Builder {
        final OFBsnTlvSrcMacCmlVer15 parentMessage;
        private boolean valueSet;
        private OFBsnCml value;

        BuilderWithParent(OFBsnTlvSrcMacCmlVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 191;
        }

        @Override
        public OFBsnCml getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvSrcMacCml.Builder setValue(OFBsnCml value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvSrcMacCml build() {
            OFBsnCml value;
            OFBsnCml oFBsnCml = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvSrcMacCmlVer15(value);
        }
    }
}

