/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnPortMode;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvPortMode;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnPortModeSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvPortModeVer15
implements OFBsnTlvPortMode {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvPortModeVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 6;
    private final OFBsnPortMode value;
    static final Reader READER = new Reader();
    static final OFBsnTlvPortModeVer15Funnel FUNNEL = new OFBsnTlvPortModeVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvPortModeVer15(OFBsnPortMode value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvPortModeVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 179;
    }

    @Override
    public OFBsnPortMode getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvPortMode.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvPortModeVer15(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvPortModeVer15 other = (OFBsnTlvPortModeVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvPortModeVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvPortModeVer15 message) {
            bb.writeShort(179);
            bb.writeShort(6);
            OFBsnPortModeSerializerVer15.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvPortModeVer15Funnel
    implements Funnel<OFBsnTlvPortModeVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvPortModeVer15Funnel() {
        }

        public void funnel(OFBsnTlvPortModeVer15 message, PrimitiveSink sink) {
            sink.putShort((short)179);
            sink.putShort((short)6);
            OFBsnPortModeSerializerVer15.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvPortMode> {
        Reader() {
        }

        @Override
        public OFBsnTlvPortMode readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 179) {
                throw new OFParseError("Wrong type: Expected=0xb3(0xb3), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnPortMode value = OFBsnPortModeSerializerVer15.readFrom(bb);
            OFBsnTlvPortModeVer15 bsnTlvPortModeVer15 = new OFBsnTlvPortModeVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvPortModeVer15);
            }
            return bsnTlvPortModeVer15;
        }
    }

    static class Builder
    implements OFBsnTlvPortMode.Builder {
        private boolean valueSet;
        private OFBsnPortMode value;

        Builder() {
        }

        @Override
        public int getType() {
            return 179;
        }

        @Override
        public OFBsnPortMode getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPortMode.Builder setValue(OFBsnPortMode value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvPortMode build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvPortModeVer15(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvPortMode.Builder {
        final OFBsnTlvPortModeVer15 parentMessage;
        private boolean valueSet;
        private OFBsnPortMode value;

        BuilderWithParent(OFBsnTlvPortModeVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 179;
        }

        @Override
        public OFBsnPortMode getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPortMode.Builder setValue(OFBsnPortMode value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvPortMode build() {
            OFBsnPortMode value;
            OFBsnPortMode oFBsnPortMode = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvPortModeVer15(value);
        }
    }
}

