/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnAnchor;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvAnchor;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnAnchorSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvAnchorVer15
implements OFBsnTlvAnchor {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvAnchorVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 6;
    private final OFBsnAnchor value;
    static final Reader READER = new Reader();
    static final OFBsnTlvAnchorVer15Funnel FUNNEL = new OFBsnTlvAnchorVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvAnchorVer15(OFBsnAnchor value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvAnchorVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 81;
    }

    @Override
    public OFBsnAnchor getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvAnchor.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvAnchorVer15(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvAnchorVer15 other = (OFBsnTlvAnchorVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvAnchorVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvAnchorVer15 message) {
            bb.writeShort(81);
            bb.writeShort(6);
            OFBsnAnchorSerializerVer15.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvAnchorVer15Funnel
    implements Funnel<OFBsnTlvAnchorVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvAnchorVer15Funnel() {
        }

        public void funnel(OFBsnTlvAnchorVer15 message, PrimitiveSink sink) {
            sink.putShort((short)81);
            sink.putShort((short)6);
            OFBsnAnchorSerializerVer15.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvAnchor> {
        Reader() {
        }

        @Override
        public OFBsnTlvAnchor readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 81) {
                throw new OFParseError("Wrong type: Expected=0x51(0x51), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnAnchor value = OFBsnAnchorSerializerVer15.readFrom(bb);
            OFBsnTlvAnchorVer15 bsnTlvAnchorVer15 = new OFBsnTlvAnchorVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvAnchorVer15);
            }
            return bsnTlvAnchorVer15;
        }
    }

    static class Builder
    implements OFBsnTlvAnchor.Builder {
        private boolean valueSet;
        private OFBsnAnchor value;

        Builder() {
        }

        @Override
        public int getType() {
            return 81;
        }

        @Override
        public OFBsnAnchor getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvAnchor.Builder setValue(OFBsnAnchor value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvAnchor build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvAnchorVer15(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvAnchor.Builder {
        final OFBsnTlvAnchorVer15 parentMessage;
        private boolean valueSet;
        private OFBsnAnchor value;

        BuilderWithParent(OFBsnTlvAnchorVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 81;
        }

        @Override
        public OFBsnAnchor getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvAnchor.Builder setValue(OFBsnAnchor value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvAnchor build() {
            OFBsnAnchor value;
            OFBsnAnchor oFBsnAnchor = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvAnchorVer15(value);
        }
    }
}

