/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionCopyTtlIn;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionCopyTtlInVer15
implements OFActionCopyTtlIn {
    private static final Logger logger = LoggerFactory.getLogger(OFActionCopyTtlInVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    static final OFActionCopyTtlInVer15 DEFAULT = new OFActionCopyTtlInVer15();
    static final OFActionCopyTtlInVer15 INSTANCE = new OFActionCopyTtlInVer15();
    static final Reader READER = new Reader();
    static final OFActionCopyTtlInVer15Funnel FUNNEL = new OFActionCopyTtlInVer15Funnel();
    static final Writer WRITER = new Writer();

    private OFActionCopyTtlInVer15() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.COPY_TTL_IN;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFActionCopyTtlIn.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionCopyTtlInVer15 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionCopyTtlInVer15(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionCopyTtlInVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionCopyTtlInVer15 message) {
            bb.writeShort(12);
            bb.writeShort(8);
            bb.writeZero(4);
        }
    }

    static class OFActionCopyTtlInVer15Funnel
    implements Funnel<OFActionCopyTtlInVer15> {
        private static final long serialVersionUID = 1L;

        OFActionCopyTtlInVer15Funnel() {
        }

        public void funnel(OFActionCopyTtlInVer15 message, PrimitiveSink sink) {
            sink.putShort((short)12);
            sink.putShort((short)8);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionCopyTtlIn> {
        Reader() {
        }

        @Override
        public OFActionCopyTtlIn readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 12) {
                throw new OFParseError("Wrong type: Expected=OFActionType.COPY_TTL_IN(12), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(4);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

