/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableConfig;
import org.projectfloodlight.openflow.protocol.OFTableFeatureFlag;
import org.projectfloodlight.openflow.protocol.OFTableFeatureProp;
import org.projectfloodlight.openflow.protocol.OFTableFeatures;
import org.projectfloodlight.openflow.protocol.OFTableFeaturesCommand;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver14.OFTableFeaturePropVer14;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableFeaturesVer14
implements OFTableFeatures {
    private static final Logger logger = LoggerFactory.getLogger(OFTableFeaturesVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 64;
    static final int MAXIMUM_LENGTH = 65535;
    private static final TableId DEFAULT_TABLE_ID = TableId.ALL;
    private static final String DEFAULT_NAME = "";
    private static final U64 DEFAULT_METADATA_MATCH = U64.ZERO;
    private static final U64 DEFAULT_METADATA_WRITE = U64.ZERO;
    private static final long DEFAULT_CONFIG = 0L;
    private static final long DEFAULT_MAX_ENTRIES = 0L;
    private static final List<OFTableFeatureProp> DEFAULT_PROPERTIES = ImmutableList.of();
    private final TableId tableId;
    private final String name;
    private final U64 metadataMatch;
    private final U64 metadataWrite;
    private final long config;
    private final long maxEntries;
    private final List<OFTableFeatureProp> properties;
    static final OFTableFeaturesVer14 DEFAULT = new OFTableFeaturesVer14(DEFAULT_TABLE_ID, "", DEFAULT_METADATA_MATCH, DEFAULT_METADATA_WRITE, 0L, 0L, DEFAULT_PROPERTIES);
    static final Reader READER = new Reader();
    static final OFTableFeaturesVer14Funnel FUNNEL = new OFTableFeaturesVer14Funnel();
    static final Writer WRITER = new Writer();

    OFTableFeaturesVer14(TableId tableId, String name, U64 metadataMatch, U64 metadataWrite, long config, long maxEntries, List<OFTableFeatureProp> properties) {
        if (tableId == null) {
            throw new NullPointerException("OFTableFeaturesVer14: property tableId cannot be null");
        }
        if (name == null) {
            throw new NullPointerException("OFTableFeaturesVer14: property name cannot be null");
        }
        if (metadataMatch == null) {
            throw new NullPointerException("OFTableFeaturesVer14: property metadataMatch cannot be null");
        }
        if (metadataWrite == null) {
            throw new NullPointerException("OFTableFeaturesVer14: property metadataWrite cannot be null");
        }
        if (properties == null) {
            throw new NullPointerException("OFTableFeaturesVer14: property properties cannot be null");
        }
        this.tableId = tableId;
        this.name = name;
        this.metadataMatch = metadataMatch;
        this.metadataWrite = metadataWrite;
        this.config = U32.normalize(config);
        this.maxEntries = U32.normalize(maxEntries);
        this.properties = properties;
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public U64 getMetadataMatch() {
        return this.metadataMatch;
    }

    @Override
    public U64 getMetadataWrite() {
        return this.metadataWrite;
    }

    @Override
    public long getConfig() {
        return this.config;
    }

    @Override
    public long getMaxEntries() {
        return this.maxEntries;
    }

    @Override
    public List<OFTableFeatureProp> getProperties() {
        return this.properties;
    }

    @Override
    public OFTableFeaturesCommand getCommand() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property command not supported in version 1.4");
    }

    @Override
    public Set<OFTableFeatureFlag> getFeatures() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property features not supported in version 1.4");
    }

    @Override
    public Set<OFTableConfig> getCapabilities() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property capabilities not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFTableFeatures.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableFeaturesVer14(");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("name=").append(this.name);
        b.append(", ");
        b.append("metadataMatch=").append(this.metadataMatch);
        b.append(", ");
        b.append("metadataWrite=").append(this.metadataWrite);
        b.append(", ");
        b.append("config=").append(this.config);
        b.append(", ");
        b.append("maxEntries=").append(this.maxEntries);
        b.append(", ");
        b.append("properties=").append(this.properties);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableFeaturesVer14 other = (OFTableFeaturesVer14)obj;
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.metadataMatch == null ? other.metadataMatch != null : !this.metadataMatch.equals(other.metadataMatch)) {
            return false;
        }
        if (this.metadataWrite == null ? other.metadataWrite != null : !this.metadataWrite.equals(other.metadataWrite)) {
            return false;
        }
        if (this.config != other.config) {
            return false;
        }
        if (this.maxEntries != other.maxEntries) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.metadataMatch == null ? 0 : this.metadataMatch.hashCode());
        result = 31 * result + (this.metadataWrite == null ? 0 : this.metadataWrite.hashCode());
        result = 31 * (int)(this.config ^ this.config >>> 32);
        result = 31 * (int)(this.maxEntries ^ this.maxEntries >>> 32);
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableFeaturesVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFTableFeaturesVer14 message) {
            int startIndex = bb.writerIndex();
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            message.tableId.writeByte(bb);
            bb.writeZero(5);
            ChannelUtils.writeFixedLengthString(bb, message.name, 32);
            bb.writeLong(message.metadataMatch.getValue());
            bb.writeLong(message.metadataWrite.getValue());
            bb.writeInt(U32.t(message.config));
            bb.writeInt(U32.t(message.maxEntries));
            ChannelUtils.writeList(bb, message.properties);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFTableFeaturesVer14: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFTableFeaturesVer14Funnel
    implements Funnel<OFTableFeaturesVer14> {
        private static final long serialVersionUID = 1L;

        OFTableFeaturesVer14Funnel() {
        }

        public void funnel(OFTableFeaturesVer14 message, PrimitiveSink sink) {
            message.tableId.putTo(sink);
            sink.putUnencodedChars((CharSequence)message.name);
            message.metadataMatch.putTo(sink);
            message.metadataWrite.putTo(sink);
            sink.putLong(message.config);
            sink.putLong(message.maxEntries);
            FunnelUtils.putList(message.properties, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableFeatures> {
        Reader() {
        }

        @Override
        public OFTableFeatures readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length < 64) {
                throw new OFParseError("Wrong length: Expected to be >= 64, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            TableId tableId = TableId.readByte(bb);
            bb.skipBytes(5);
            String name = ChannelUtils.readFixedLengthString(bb, 32);
            U64 metadataMatch = U64.ofRaw(bb.readLong());
            U64 metadataWrite = U64.ofRaw(bb.readLong());
            long config = U32.f(bb.readInt());
            long maxEntries = U32.f(bb.readInt());
            List<OFTableFeatureProp> properties = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFTableFeaturePropVer14.READER);
            OFTableFeaturesVer14 tableFeaturesVer14 = new OFTableFeaturesVer14(tableId, name, metadataMatch, metadataWrite, config, maxEntries, properties);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableFeaturesVer14);
            }
            return tableFeaturesVer14;
        }
    }

    static class Builder
    implements OFTableFeatures.Builder {
        private boolean tableIdSet;
        private TableId tableId;
        private boolean nameSet;
        private String name;
        private boolean metadataMatchSet;
        private U64 metadataMatch;
        private boolean metadataWriteSet;
        private U64 metadataWrite;
        private boolean configSet;
        private long config;
        private boolean maxEntriesSet;
        private long maxEntries;
        private boolean propertiesSet;
        private List<OFTableFeatureProp> properties;

        Builder() {
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFTableFeatures.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFTableFeatures.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public U64 getMetadataMatch() {
            return this.metadataMatch;
        }

        @Override
        public OFTableFeatures.Builder setMetadataMatch(U64 metadataMatch) {
            this.metadataMatch = metadataMatch;
            this.metadataMatchSet = true;
            return this;
        }

        @Override
        public U64 getMetadataWrite() {
            return this.metadataWrite;
        }

        @Override
        public OFTableFeatures.Builder setMetadataWrite(U64 metadataWrite) {
            this.metadataWrite = metadataWrite;
            this.metadataWriteSet = true;
            return this;
        }

        @Override
        public long getConfig() {
            return this.config;
        }

        @Override
        public OFTableFeatures.Builder setConfig(long config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public long getMaxEntries() {
            return this.maxEntries;
        }

        @Override
        public OFTableFeatures.Builder setMaxEntries(long maxEntries) {
            this.maxEntries = maxEntries;
            this.maxEntriesSet = true;
            return this;
        }

        @Override
        public List<OFTableFeatureProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFTableFeatures.Builder setProperties(List<OFTableFeatureProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFTableFeaturesCommand getCommand() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property command not supported in version 1.4");
        }

        @Override
        public OFTableFeatures.Builder setCommand(OFTableFeaturesCommand command) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property command not supported in version 1.4");
        }

        @Override
        public Set<OFTableFeatureFlag> getFeatures() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property features not supported in version 1.4");
        }

        @Override
        public OFTableFeatures.Builder setFeatures(Set<OFTableFeatureFlag> features) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property features not supported in version 1.4");
        }

        @Override
        public Set<OFTableConfig> getCapabilities() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property capabilities not supported in version 1.4");
        }

        @Override
        public OFTableFeatures.Builder setCapabilities(Set<OFTableConfig> capabilities) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property capabilities not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFTableFeatures build() {
            List<OFTableFeatureProp> properties;
            U64 metadataWrite;
            U64 metadataMatch;
            String name;
            TableId tableId;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            String string = name = this.nameSet ? this.name : OFTableFeaturesVer14.DEFAULT_NAME;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            U64 u64 = metadataMatch = this.metadataMatchSet ? this.metadataMatch : DEFAULT_METADATA_MATCH;
            if (metadataMatch == null) {
                throw new NullPointerException("Property metadataMatch must not be null");
            }
            U64 u642 = metadataWrite = this.metadataWriteSet ? this.metadataWrite : DEFAULT_METADATA_WRITE;
            if (metadataWrite == null) {
                throw new NullPointerException("Property metadataWrite must not be null");
            }
            long config = this.configSet ? this.config : 0L;
            long maxEntries = this.maxEntriesSet ? this.maxEntries : 0L;
            List<OFTableFeatureProp> list = properties = this.propertiesSet ? this.properties : DEFAULT_PROPERTIES;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFTableFeaturesVer14(tableId, name, metadataMatch, metadataWrite, config, maxEntries, properties);
        }
    }

    static class BuilderWithParent
    implements OFTableFeatures.Builder {
        final OFTableFeaturesVer14 parentMessage;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean nameSet;
        private String name;
        private boolean metadataMatchSet;
        private U64 metadataMatch;
        private boolean metadataWriteSet;
        private U64 metadataWrite;
        private boolean configSet;
        private long config;
        private boolean maxEntriesSet;
        private long maxEntries;
        private boolean propertiesSet;
        private List<OFTableFeatureProp> properties;

        BuilderWithParent(OFTableFeaturesVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFTableFeatures.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFTableFeatures.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public U64 getMetadataMatch() {
            return this.metadataMatch;
        }

        @Override
        public OFTableFeatures.Builder setMetadataMatch(U64 metadataMatch) {
            this.metadataMatch = metadataMatch;
            this.metadataMatchSet = true;
            return this;
        }

        @Override
        public U64 getMetadataWrite() {
            return this.metadataWrite;
        }

        @Override
        public OFTableFeatures.Builder setMetadataWrite(U64 metadataWrite) {
            this.metadataWrite = metadataWrite;
            this.metadataWriteSet = true;
            return this;
        }

        @Override
        public long getConfig() {
            return this.config;
        }

        @Override
        public OFTableFeatures.Builder setConfig(long config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public long getMaxEntries() {
            return this.maxEntries;
        }

        @Override
        public OFTableFeatures.Builder setMaxEntries(long maxEntries) {
            this.maxEntries = maxEntries;
            this.maxEntriesSet = true;
            return this;
        }

        @Override
        public List<OFTableFeatureProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFTableFeatures.Builder setProperties(List<OFTableFeatureProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFTableFeaturesCommand getCommand() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property command not supported in version 1.4");
        }

        @Override
        public OFTableFeatures.Builder setCommand(OFTableFeaturesCommand command) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property command not supported in version 1.4");
        }

        @Override
        public Set<OFTableFeatureFlag> getFeatures() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property features not supported in version 1.4");
        }

        @Override
        public OFTableFeatures.Builder setFeatures(Set<OFTableFeatureFlag> features) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property features not supported in version 1.4");
        }

        @Override
        public Set<OFTableConfig> getCapabilities() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property capabilities not supported in version 1.4");
        }

        @Override
        public OFTableFeatures.Builder setCapabilities(Set<OFTableConfig> capabilities) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property capabilities not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFTableFeatures build() {
            List properties;
            U64 metadataWrite;
            U64 metadataMatch;
            String name;
            TableId tableId;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            String string = name = this.nameSet ? this.name : this.parentMessage.name;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            U64 u64 = metadataMatch = this.metadataMatchSet ? this.metadataMatch : this.parentMessage.metadataMatch;
            if (metadataMatch == null) {
                throw new NullPointerException("Property metadataMatch must not be null");
            }
            U64 u642 = metadataWrite = this.metadataWriteSet ? this.metadataWrite : this.parentMessage.metadataWrite;
            if (metadataWrite == null) {
                throw new NullPointerException("Property metadataWrite must not be null");
            }
            long config = this.configSet ? this.config : this.parentMessage.config;
            long maxEntries = this.maxEntriesSet ? this.maxEntries : this.parentMessage.maxEntries;
            List list = properties = this.propertiesSet ? this.properties : this.parentMessage.properties;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFTableFeaturesVer14(tableId, name, metadataMatch, metadataWrite, config, maxEntries, properties);
        }
    }
}

