/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFPortState;

public class OFPortStateSerializerVer14 {
    public static final int LINK_DOWN_VAL = 1;
    public static final int BLOCKED_VAL = 2;
    public static final int LIVE_VAL = 4;

    public static Set<OFPortState> readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFPortStateSerializerVer14.ofWireValue(bb.readInt());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, Set<OFPortState> set) {
        bb.writeInt(OFPortStateSerializerVer14.toWireValue(set));
    }

    public static void putTo(Set<OFPortState> set, PrimitiveSink sink) {
        sink.putInt(OFPortStateSerializerVer14.toWireValue(set));
    }

    public static Set<OFPortState> ofWireValue(int val) {
        EnumSet<OFPortState> set = EnumSet.noneOf(OFPortState.class);
        if ((val & 1) != 0) {
            set.add(OFPortState.LINK_DOWN);
        }
        if ((val & 2) != 0) {
            set.add(OFPortState.BLOCKED);
        }
        if ((val & 4) != 0) {
            set.add(OFPortState.LIVE);
        }
        return Collections.unmodifiableSet(set);
    }

    public static int toWireValue(Set<OFPortState> set) {
        int wireValue = 0;
        block5: for (OFPortState e : set) {
            switch (e) {
                case LINK_DOWN: {
                    wireValue |= 1;
                    continue block5;
                }
                case BLOCKED: {
                    wireValue |= 2;
                    continue block5;
                }
                case LIVE: {
                    wireValue |= 4;
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Illegal enum value for type OFPortState in version 1.4: " + (Object)((Object)e));
        }
        return wireValue;
    }
}

