/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortDescStatsRequest;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver14.OFStatsRequestFlagsSerializerVer14;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortDescStatsRequestVer14
implements OFPortDescStatsRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFPortDescStatsRequestVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 16;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsRequestFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private final long xid;
    private final Set<OFStatsRequestFlags> flags;
    static final OFPortDescStatsRequestVer14 DEFAULT = new OFPortDescStatsRequestVer14(0L, DEFAULT_FLAGS);
    static final Reader READER = new Reader();
    static final OFPortDescStatsRequestVer14Funnel FUNNEL = new OFPortDescStatsRequestVer14Funnel();
    static final Writer WRITER = new Writer();

    OFPortDescStatsRequestVer14(long xid, Set<OFStatsRequestFlags> flags) {
        if (flags == null) {
            throw new NullPointerException("OFPortDescStatsRequestVer14: property flags cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.flags = flags;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.PORT_DESC;
    }

    @Override
    public Set<OFStatsRequestFlags> getFlags() {
        return this.flags;
    }

    @Override
    public OFPort getPortNo() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property portNo not supported in version 1.4");
    }

    @Override
    public OFPortDescStatsRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortDescStatsRequestVer14(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortDescStatsRequestVer14 other = (OFPortDescStatsRequestVer14)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return !(this.flags == null ? other.flags != null : !this.flags.equals(other.flags));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortDescStatsRequestVer14 other = (OFPortDescStatsRequestVer14)obj;
        return !(this.flags == null ? other.flags != null : !this.flags.equals(other.flags));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortDescStatsRequestVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPortDescStatsRequestVer14 message) {
            bb.writeByte(5);
            bb.writeByte(18);
            bb.writeShort(16);
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(13);
            OFStatsRequestFlagsSerializerVer14.writeTo(bb, message.flags);
            bb.writeZero(4);
        }
    }

    static class OFPortDescStatsRequestVer14Funnel
    implements Funnel<OFPortDescStatsRequestVer14> {
        private static final long serialVersionUID = 1L;

        OFPortDescStatsRequestVer14Funnel() {
        }

        public void funnel(OFPortDescStatsRequestVer14 message, PrimitiveSink sink) {
            sink.putByte((byte)5);
            sink.putByte((byte)18);
            sink.putShort((short)16);
            sink.putLong(message.xid);
            sink.putShort((short)13);
            OFStatsRequestFlagsSerializerVer14.putTo(message.flags, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortDescStatsRequest> {
        Reader() {
        }

        @Override
        public OFPortDescStatsRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != 13) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.PORT_DESC(13), got=" + statsType);
            }
            Set<OFStatsRequestFlags> flags = OFStatsRequestFlagsSerializerVer14.readFrom(bb);
            bb.skipBytes(4);
            OFPortDescStatsRequestVer14 portDescStatsRequestVer14 = new OFPortDescStatsRequestVer14(xid, flags);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portDescStatsRequestVer14);
            }
            return portDescStatsRequestVer14;
        }
    }

    static class Builder
    implements OFPortDescStatsRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFPortDescStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.PORT_DESC;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFPortDescStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property portNo not supported in version 1.4");
        }

        @Override
        public OFPortDescStatsRequest.Builder setPortNo(OFPort portNo) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property portNo not supported in version 1.4");
        }

        @Override
        public OFPortDescStatsRequest build() {
            Set<OFStatsRequestFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsRequestFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            return new OFPortDescStatsRequestVer14(xid, flags);
        }
    }

    static class BuilderWithParent
    implements OFPortDescStatsRequest.Builder {
        final OFPortDescStatsRequestVer14 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;

        BuilderWithParent(OFPortDescStatsRequestVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFPortDescStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.PORT_DESC;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFPortDescStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property portNo not supported in version 1.4");
        }

        @Override
        public OFPortDescStatsRequest.Builder setPortNo(OFPort portNo) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property portNo not supported in version 1.4");
        }

        @Override
        public OFPortDescStatsRequest build() {
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            return new OFPortDescStatsRequestVer14(xid, flags);
        }
    }
}

