/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortDescPropBsnGenerationId;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortDescPropBsnGenerationIdVer14
implements OFPortDescPropBsnGenerationId {
    private static final Logger logger = LoggerFactory.getLogger(OFPortDescPropBsnGenerationIdVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 20;
    private static final U64 DEFAULT_GENERATION_ID = U64.ZERO;
    private final U64 generationId;
    static final OFPortDescPropBsnGenerationIdVer14 DEFAULT = new OFPortDescPropBsnGenerationIdVer14(DEFAULT_GENERATION_ID);
    static final Reader READER = new Reader();
    static final OFPortDescPropBsnGenerationIdVer14Funnel FUNNEL = new OFPortDescPropBsnGenerationIdVer14Funnel();
    static final Writer WRITER = new Writer();

    OFPortDescPropBsnGenerationIdVer14(U64 generationId) {
        if (generationId == null) {
            throw new NullPointerException("OFPortDescPropBsnGenerationIdVer14: property generationId cannot be null");
        }
        this.generationId = generationId;
    }

    @Override
    public int getType() {
        return 65535;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getExpType() {
        return 1L;
    }

    @Override
    public U64 getGenerationId() {
        return this.generationId;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFPortDescPropBsnGenerationId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortDescPropBsnGenerationIdVer14(");
        b.append("generationId=").append(this.generationId);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortDescPropBsnGenerationIdVer14 other = (OFPortDescPropBsnGenerationIdVer14)obj;
        return !(this.generationId == null ? other.generationId != null : !this.generationId.equals(other.generationId));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.generationId == null ? 0 : this.generationId.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortDescPropBsnGenerationIdVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPortDescPropBsnGenerationIdVer14 message) {
            bb.writeShort(-1);
            bb.writeShort(20);
            bb.writeInt(6035143);
            bb.writeInt(1);
            bb.writeLong(message.generationId.getValue());
        }
    }

    static class OFPortDescPropBsnGenerationIdVer14Funnel
    implements Funnel<OFPortDescPropBsnGenerationIdVer14> {
        private static final long serialVersionUID = 1L;

        OFPortDescPropBsnGenerationIdVer14Funnel() {
        }

        public void funnel(OFPortDescPropBsnGenerationIdVer14 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)20);
            sink.putInt(6035143);
            sink.putInt(1);
            message.generationId.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortDescPropBsnGenerationId> {
        Reader() {
        }

        @Override
        public OFPortDescPropBsnGenerationId readFrom(ByteBuf bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=0xffff(0xffff), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 20) {
                throw new OFParseError("Wrong length: Expected=20(20), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int expType = bb.readInt();
            if (expType != 1) {
                throw new OFParseError("Wrong expType: Expected=0x1L(0x1L), got=" + expType);
            }
            U64 generationId = U64.ofRaw(bb.readLong());
            OFPortDescPropBsnGenerationIdVer14 portDescPropBsnGenerationIdVer14 = new OFPortDescPropBsnGenerationIdVer14(generationId);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portDescPropBsnGenerationIdVer14);
            }
            return portDescPropBsnGenerationIdVer14;
        }
    }

    static class Builder
    implements OFPortDescPropBsnGenerationId.Builder {
        private boolean generationIdSet;
        private U64 generationId;

        Builder() {
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getExpType() {
            return 1L;
        }

        @Override
        public OFPortDescPropBsnGenerationId.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
        }

        @Override
        public U64 getGenerationId() {
            return this.generationId;
        }

        @Override
        public OFPortDescPropBsnGenerationId.Builder setGenerationId(U64 generationId) {
            this.generationId = generationId;
            this.generationIdSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFPortDescPropBsnGenerationId build() {
            U64 generationId;
            U64 u64 = generationId = this.generationIdSet ? this.generationId : DEFAULT_GENERATION_ID;
            if (generationId == null) {
                throw new NullPointerException("Property generationId must not be null");
            }
            return new OFPortDescPropBsnGenerationIdVer14(generationId);
        }
    }

    static class BuilderWithParent
    implements OFPortDescPropBsnGenerationId.Builder {
        final OFPortDescPropBsnGenerationIdVer14 parentMessage;
        private boolean generationIdSet;
        private U64 generationId;

        BuilderWithParent(OFPortDescPropBsnGenerationIdVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getExpType() {
            return 1L;
        }

        @Override
        public OFPortDescPropBsnGenerationId.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
        }

        @Override
        public U64 getGenerationId() {
            return this.generationId;
        }

        @Override
        public OFPortDescPropBsnGenerationId.Builder setGenerationId(U64 generationId) {
            this.generationId = generationId;
            this.generationIdSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFPortDescPropBsnGenerationId build() {
            U64 generationId;
            U64 u64 = generationId = this.generationIdSet ? this.generationId : this.parentMessage.generationId;
            if (generationId == null) {
                throw new NullPointerException("Property generationId must not be null");
            }
            return new OFPortDescPropBsnGenerationIdVer14(generationId);
        }
    }
}

