/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmPbbUcaMasked;
import org.projectfloodlight.openflow.protocol.ver14.OFOxmPbbUcaVer14;
import org.projectfloodlight.openflow.types.OFBooleanValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmPbbUcaMaskedVer14
implements OFOxmPbbUcaMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmPbbUcaMaskedVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 6;
    private static final OFBooleanValue DEFAULT_VALUE = OFBooleanValue.FALSE;
    private static final OFBooleanValue DEFAULT_VALUE_MASK = OFBooleanValue.FALSE;
    private final OFBooleanValue value;
    private final OFBooleanValue mask;
    static final OFOxmPbbUcaMaskedVer14 DEFAULT = new OFOxmPbbUcaMaskedVer14(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmPbbUcaMaskedVer14Funnel FUNNEL = new OFOxmPbbUcaMaskedVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmPbbUcaMaskedVer14(OFBooleanValue value, OFBooleanValue mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmPbbUcaMaskedVer14: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmPbbUcaMaskedVer14: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 2147504898L;
    }

    @Override
    public OFBooleanValue getValue() {
        return this.value;
    }

    @Override
    public OFBooleanValue getMask() {
        return this.mask;
    }

    @Override
    public MatchField<OFBooleanValue> getMatchField() {
        return MatchField.PBB_UCA;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<OFBooleanValue> getCanonical() {
        if (OFBooleanValue.NO_MASK.equals(this.mask)) {
            return new OFOxmPbbUcaVer14(this.value);
        }
        if (OFBooleanValue.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmPbbUcaMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmPbbUcaMaskedVer14(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmPbbUcaMaskedVer14 other = (OFOxmPbbUcaMaskedVer14)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmPbbUcaMaskedVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmPbbUcaMaskedVer14 message) {
            bb.writeInt(-2147462398);
            bb.writeByte(message.value.getInt());
            bb.writeByte(message.mask.getInt());
        }
    }

    static class OFOxmPbbUcaMaskedVer14Funnel
    implements Funnel<OFOxmPbbUcaMaskedVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmPbbUcaMaskedVer14Funnel() {
        }

        public void funnel(OFOxmPbbUcaMaskedVer14 message, PrimitiveSink sink) {
            sink.putInt(-2147462398);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmPbbUcaMasked> {
        Reader() {
        }

        @Override
        public OFOxmPbbUcaMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147462398) {
                throw new OFParseError("Wrong typeLen: Expected=0x80005302L(0x80005302L), got=" + typeLen);
            }
            OFBooleanValue value = OFBooleanValue.of(bb.readByte() != 0);
            OFBooleanValue mask = OFBooleanValue.of(bb.readByte() != 0);
            OFOxmPbbUcaMaskedVer14 oxmPbbUcaMaskedVer14 = new OFOxmPbbUcaMaskedVer14(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmPbbUcaMaskedVer14);
            }
            return oxmPbbUcaMaskedVer14;
        }
    }

    static class Builder
    implements OFOxmPbbUcaMasked.Builder {
        private boolean valueSet;
        private OFBooleanValue value;
        private boolean maskSet;
        private OFBooleanValue mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147504898L;
        }

        @Override
        public OFBooleanValue getValue() {
            return this.value;
        }

        @Override
        public OFOxmPbbUcaMasked.Builder setValue(OFBooleanValue value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFBooleanValue getMask() {
            return this.mask;
        }

        @Override
        public OFOxmPbbUcaMasked.Builder setMask(OFBooleanValue mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<OFBooleanValue> getMatchField() {
            return MatchField.PBB_UCA;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<OFBooleanValue> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmPbbUcaMasked build() {
            OFBooleanValue mask;
            OFBooleanValue value;
            OFBooleanValue oFBooleanValue = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            OFBooleanValue oFBooleanValue2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmPbbUcaMaskedVer14(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmPbbUcaMasked.Builder {
        final OFOxmPbbUcaMaskedVer14 parentMessage;
        private boolean valueSet;
        private OFBooleanValue value;
        private boolean maskSet;
        private OFBooleanValue mask;

        BuilderWithParent(OFOxmPbbUcaMaskedVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147504898L;
        }

        @Override
        public OFBooleanValue getValue() {
            return this.value;
        }

        @Override
        public OFOxmPbbUcaMasked.Builder setValue(OFBooleanValue value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFBooleanValue getMask() {
            return this.mask;
        }

        @Override
        public OFOxmPbbUcaMasked.Builder setMask(OFBooleanValue mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<OFBooleanValue> getMatchField() {
            return MatchField.PBB_UCA;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<OFBooleanValue> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmPbbUcaMasked build() {
            OFBooleanValue mask;
            OFBooleanValue value;
            OFBooleanValue oFBooleanValue = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            OFBooleanValue oFBooleanValue2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmPbbUcaMaskedVer14(value, mask);
        }
    }
}

