/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmInPhyPortMasked;
import org.projectfloodlight.openflow.protocol.ver14.OFOxmInPhyPortVer14;
import org.projectfloodlight.openflow.types.OFPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmInPhyPortMaskedVer14
implements OFOxmInPhyPortMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmInPhyPortMaskedVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 12;
    private static final OFPort DEFAULT_VALUE = OFPort.ANY;
    private static final OFPort DEFAULT_VALUE_MASK = OFPort.ANY;
    private final OFPort value;
    private final OFPort mask;
    static final OFOxmInPhyPortMaskedVer14 DEFAULT = new OFOxmInPhyPortMaskedVer14(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmInPhyPortMaskedVer14Funnel FUNNEL = new OFOxmInPhyPortMaskedVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmInPhyPortMaskedVer14(OFPort value, OFPort mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmInPhyPortMaskedVer14: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmInPhyPortMaskedVer14: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 0x80000308L;
    }

    @Override
    public OFPort getValue() {
        return this.value;
    }

    @Override
    public OFPort getMask() {
        return this.mask;
    }

    @Override
    public MatchField<OFPort> getMatchField() {
        return MatchField.IN_PHY_PORT;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<OFPort> getCanonical() {
        if (OFPort.NO_MASK.equals(this.mask)) {
            return new OFOxmInPhyPortVer14(this.value);
        }
        if (OFPort.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmInPhyPortMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmInPhyPortMaskedVer14(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmInPhyPortMaskedVer14 other = (OFOxmInPhyPortMaskedVer14)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmInPhyPortMaskedVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmInPhyPortMaskedVer14 message) {
            bb.writeInt(-2147482872);
            message.value.write4Bytes(bb);
            message.mask.write4Bytes(bb);
        }
    }

    static class OFOxmInPhyPortMaskedVer14Funnel
    implements Funnel<OFOxmInPhyPortMaskedVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmInPhyPortMaskedVer14Funnel() {
        }

        public void funnel(OFOxmInPhyPortMaskedVer14 message, PrimitiveSink sink) {
            sink.putInt(-2147482872);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmInPhyPortMasked> {
        Reader() {
        }

        @Override
        public OFOxmInPhyPortMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147482872) {
                throw new OFParseError("Wrong typeLen: Expected=0x80000308L(0x80000308L), got=" + typeLen);
            }
            OFPort value = OFPort.read4Bytes(bb);
            OFPort mask = OFPort.read4Bytes(bb);
            OFOxmInPhyPortMaskedVer14 oxmInPhyPortMaskedVer14 = new OFOxmInPhyPortMaskedVer14(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmInPhyPortMaskedVer14);
            }
            return oxmInPhyPortMaskedVer14;
        }
    }

    static class Builder
    implements OFOxmInPhyPortMasked.Builder {
        private boolean valueSet;
        private OFPort value;
        private boolean maskSet;
        private OFPort mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 0x80000308L;
        }

        @Override
        public OFPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmInPhyPortMasked.Builder setValue(OFPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFPort getMask() {
            return this.mask;
        }

        @Override
        public OFOxmInPhyPortMasked.Builder setMask(OFPort mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<OFPort> getMatchField() {
            return MatchField.IN_PHY_PORT;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<OFPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmInPhyPortMasked build() {
            OFPort mask;
            OFPort value;
            OFPort oFPort = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            OFPort oFPort2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmInPhyPortMaskedVer14(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmInPhyPortMasked.Builder {
        final OFOxmInPhyPortMaskedVer14 parentMessage;
        private boolean valueSet;
        private OFPort value;
        private boolean maskSet;
        private OFPort mask;

        BuilderWithParent(OFOxmInPhyPortMaskedVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 0x80000308L;
        }

        @Override
        public OFPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmInPhyPortMasked.Builder setValue(OFPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFPort getMask() {
            return this.mask;
        }

        @Override
        public OFOxmInPhyPortMasked.Builder setMask(OFPort mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<OFPort> getMatchField() {
            return MatchField.IN_PHY_PORT;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<OFPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmInPhyPortMasked build() {
            OFPort mask;
            OFPort value;
            OFPort oFPort = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            OFPort oFPort2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmInPhyPortMaskedVer14(value, mask);
        }
    }
}

