/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFInstructionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.instructionid.OFInstructionIdWriteActions;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFInstructionIdWriteActionsVer14
implements OFInstructionIdWriteActions {
    private static final Logger logger = LoggerFactory.getLogger(OFInstructionIdWriteActionsVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 4;
    static final OFInstructionIdWriteActionsVer14 DEFAULT = new OFInstructionIdWriteActionsVer14();
    static final OFInstructionIdWriteActionsVer14 INSTANCE = new OFInstructionIdWriteActionsVer14();
    static final Reader READER = new Reader();
    static final OFInstructionIdWriteActionsVer14Funnel FUNNEL = new OFInstructionIdWriteActionsVer14Funnel();
    static final Writer WRITER = new Writer();

    private OFInstructionIdWriteActionsVer14() {
    }

    @Override
    public OFInstructionType getType() {
        return OFInstructionType.WRITE_ACTIONS;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFInstructionIdWriteActions.Builder createBuilder() {
        throw new UnsupportedOperationException("OFInstructionIdWriteActionsVer14 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFInstructionIdWriteActionsVer14(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFInstructionIdWriteActionsVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFInstructionIdWriteActionsVer14 message) {
            bb.writeShort(3);
            bb.writeShort(4);
        }
    }

    static class OFInstructionIdWriteActionsVer14Funnel
    implements Funnel<OFInstructionIdWriteActionsVer14> {
        private static final long serialVersionUID = 1L;

        OFInstructionIdWriteActionsVer14Funnel() {
        }

        public void funnel(OFInstructionIdWriteActionsVer14 message, PrimitiveSink sink) {
            sink.putShort((short)3);
            sink.putShort((short)4);
        }
    }

    static class Reader
    implements OFMessageReader<OFInstructionIdWriteActions> {
        Reader() {
        }

        @Override
        public OFInstructionIdWriteActions readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 3) {
                throw new OFParseError("Wrong type: Expected=OFInstructionType.WRITE_ACTIONS(3), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 4) {
                throw new OFParseError("Wrong length: Expected=4(4), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

