/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlv;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvReference;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnTlvVer14;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvReferenceVer14
implements OFBsnTlvReference {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvReferenceVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 6;
    static final int MAXIMUM_LENGTH = 65535;
    private static final int DEFAULT_TABLE_ID = 0;
    private static final List<OFBsnTlv> DEFAULT_KEY = ImmutableList.of();
    private final int tableId;
    private final List<OFBsnTlv> key;
    static final OFBsnTlvReferenceVer14 DEFAULT = new OFBsnTlvReferenceVer14(0, DEFAULT_KEY);
    static final Reader READER = new Reader();
    static final OFBsnTlvReferenceVer14Funnel FUNNEL = new OFBsnTlvReferenceVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvReferenceVer14(int tableId, List<OFBsnTlv> key) {
        if (key == null) {
            throw new NullPointerException("OFBsnTlvReferenceVer14: property key cannot be null");
        }
        this.tableId = U16.normalize(tableId);
        this.key = key;
    }

    @Override
    public int getType() {
        return 59;
    }

    @Override
    public int getTableId() {
        return this.tableId;
    }

    @Override
    public List<OFBsnTlv> getKey() {
        return this.key;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvReference.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvReferenceVer14(");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("key=").append(this.key);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvReferenceVer14 other = (OFBsnTlvReferenceVer14)obj;
        if (this.tableId != other.tableId) {
            return false;
        }
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.tableId;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvReferenceVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvReferenceVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(59);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeShort((int)U16.t(message.tableId));
            ChannelUtils.writeList(bb, message.key);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFBsnTlvReferenceVer14: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnTlvReferenceVer14Funnel
    implements Funnel<OFBsnTlvReferenceVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvReferenceVer14Funnel() {
        }

        public void funnel(OFBsnTlvReferenceVer14 message, PrimitiveSink sink) {
            sink.putShort((short)59);
            sink.putInt(message.tableId);
            FunnelUtils.putList(message.key, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvReference> {
        Reader() {
        }

        @Override
        public OFBsnTlvReference readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 59) {
                throw new OFParseError("Wrong type: Expected=0x3b(0x3b), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 6) {
                throw new OFParseError("Wrong length: Expected to be >= 6, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int tableId = U16.f(bb.readShort());
            List<OFBsnTlv> key = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFBsnTlvVer14.READER);
            OFBsnTlvReferenceVer14 bsnTlvReferenceVer14 = new OFBsnTlvReferenceVer14(tableId, key);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvReferenceVer14);
            }
            return bsnTlvReferenceVer14;
        }
    }

    static class Builder
    implements OFBsnTlvReference.Builder {
        private boolean tableIdSet;
        private int tableId;
        private boolean keySet;
        private List<OFBsnTlv> key;

        Builder() {
        }

        @Override
        public int getType() {
            return 59;
        }

        @Override
        public int getTableId() {
            return this.tableId;
        }

        @Override
        public OFBsnTlvReference.Builder setTableId(int tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public List<OFBsnTlv> getKey() {
            return this.key;
        }

        @Override
        public OFBsnTlvReference.Builder setKey(List<OFBsnTlv> key) {
            this.key = key;
            this.keySet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvReference build() {
            List<OFBsnTlv> key;
            int tableId = this.tableIdSet ? this.tableId : 0;
            List<OFBsnTlv> list = key = this.keySet ? this.key : DEFAULT_KEY;
            if (key == null) {
                throw new NullPointerException("Property key must not be null");
            }
            return new OFBsnTlvReferenceVer14(tableId, key);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvReference.Builder {
        final OFBsnTlvReferenceVer14 parentMessage;
        private boolean tableIdSet;
        private int tableId;
        private boolean keySet;
        private List<OFBsnTlv> key;

        BuilderWithParent(OFBsnTlvReferenceVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 59;
        }

        @Override
        public int getTableId() {
            return this.tableId;
        }

        @Override
        public OFBsnTlvReference.Builder setTableId(int tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public List<OFBsnTlv> getKey() {
            return this.key;
        }

        @Override
        public OFBsnTlvReference.Builder setKey(List<OFBsnTlv> key) {
            this.key = key;
            this.keySet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvReference build() {
            List key;
            int tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            List list = key = this.keySet ? this.key : this.parentMessage.key;
            if (key == null) {
                throw new NullPointerException("Property key must not be null");
            }
            return new OFBsnTlvReferenceVer14(tableId, key);
        }
    }
}

