/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvLoopbackPort;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvLoopbackPortVer14
implements OFBsnTlvLoopbackPort {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvLoopbackPortVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final OFPort DEFAULT_VALUE = OFPort.ANY;
    private final OFPort value;
    static final OFBsnTlvLoopbackPortVer14 DEFAULT = new OFBsnTlvLoopbackPortVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvLoopbackPortVer14Funnel FUNNEL = new OFBsnTlvLoopbackPortVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvLoopbackPortVer14(OFPort value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvLoopbackPortVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 110;
    }

    @Override
    public OFPort getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvLoopbackPort.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvLoopbackPortVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvLoopbackPortVer14 other = (OFBsnTlvLoopbackPortVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvLoopbackPortVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvLoopbackPortVer14 message) {
            bb.writeShort(110);
            bb.writeShort(8);
            message.value.write4Bytes(bb);
        }
    }

    static class OFBsnTlvLoopbackPortVer14Funnel
    implements Funnel<OFBsnTlvLoopbackPortVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvLoopbackPortVer14Funnel() {
        }

        public void funnel(OFBsnTlvLoopbackPortVer14 message, PrimitiveSink sink) {
            sink.putShort((short)110);
            sink.putShort((short)8);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvLoopbackPort> {
        Reader() {
        }

        @Override
        public OFBsnTlvLoopbackPort readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 110) {
                throw new OFParseError("Wrong type: Expected=0x6e(0x6e), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFPort value = OFPort.read4Bytes(bb);
            OFBsnTlvLoopbackPortVer14 bsnTlvLoopbackPortVer14 = new OFBsnTlvLoopbackPortVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvLoopbackPortVer14);
            }
            return bsnTlvLoopbackPortVer14;
        }
    }

    static class Builder
    implements OFBsnTlvLoopbackPort.Builder {
        private boolean valueSet;
        private OFPort value;

        Builder() {
        }

        @Override
        public int getType() {
            return 110;
        }

        @Override
        public OFPort getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvLoopbackPort.Builder setValue(OFPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvLoopbackPort build() {
            OFPort value;
            OFPort oFPort = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvLoopbackPortVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvLoopbackPort.Builder {
        final OFBsnTlvLoopbackPortVer14 parentMessage;
        private boolean valueSet;
        private OFPort value;

        BuilderWithParent(OFBsnTlvLoopbackPortVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 110;
        }

        @Override
        public OFPort getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvLoopbackPort.Builder setValue(OFPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvLoopbackPort build() {
            OFPort value;
            OFPort oFPort = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvLoopbackPortVer14(value);
        }
    }
}

