/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionDecMplsTtl;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionDecMplsTtlVer14
implements OFActionDecMplsTtl {
    private static final Logger logger = LoggerFactory.getLogger(OFActionDecMplsTtlVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    static final OFActionDecMplsTtlVer14 DEFAULT = new OFActionDecMplsTtlVer14();
    static final OFActionDecMplsTtlVer14 INSTANCE = new OFActionDecMplsTtlVer14();
    static final Reader READER = new Reader();
    static final OFActionDecMplsTtlVer14Funnel FUNNEL = new OFActionDecMplsTtlVer14Funnel();
    static final Writer WRITER = new Writer();

    private OFActionDecMplsTtlVer14() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.DEC_MPLS_TTL;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFActionDecMplsTtl.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionDecMplsTtlVer14 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionDecMplsTtlVer14(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionDecMplsTtlVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionDecMplsTtlVer14 message) {
            bb.writeShort(16);
            bb.writeShort(8);
            bb.writeZero(4);
        }
    }

    static class OFActionDecMplsTtlVer14Funnel
    implements Funnel<OFActionDecMplsTtlVer14> {
        private static final long serialVersionUID = 1L;

        OFActionDecMplsTtlVer14Funnel() {
        }

        public void funnel(OFActionDecMplsTtlVer14 message, PrimitiveSink sink) {
            sink.putShort((short)16);
            sink.putShort((short)8);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionDecMplsTtl> {
        Reader() {
        }

        @Override
        public OFActionDecMplsTtl readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 16) {
                throw new OFParseError("Wrong type: Expected=OFActionType.DEC_MPLS_TTL(16), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(4);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

