/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmSctpDstMasked;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmSctpDstVer13;
import org.projectfloodlight.openflow.types.TransportPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmSctpDstMaskedVer13
implements OFOxmSctpDstMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmSctpDstMaskedVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final TransportPort DEFAULT_VALUE = TransportPort.NONE;
    private static final TransportPort DEFAULT_VALUE_MASK = TransportPort.NONE;
    private final TransportPort value;
    private final TransportPort mask;
    static final OFOxmSctpDstMaskedVer13 DEFAULT = new OFOxmSctpDstMaskedVer13(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmSctpDstMaskedVer13Funnel FUNNEL = new OFOxmSctpDstMaskedVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmSctpDstMaskedVer13(TransportPort value, TransportPort mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmSctpDstMaskedVer13: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmSctpDstMaskedVer13: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 2147493124L;
    }

    @Override
    public TransportPort getValue() {
        return this.value;
    }

    @Override
    public TransportPort getMask() {
        return this.mask;
    }

    @Override
    public MatchField<TransportPort> getMatchField() {
        return MatchField.SCTP_DST;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<TransportPort> getCanonical() {
        if (TransportPort.NO_MASK.equals(this.mask)) {
            return new OFOxmSctpDstVer13(this.value);
        }
        if (TransportPort.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmSctpDstMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmSctpDstMaskedVer13(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmSctpDstMaskedVer13 other = (OFOxmSctpDstMaskedVer13)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmSctpDstMaskedVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmSctpDstMaskedVer13 message) {
            bb.writeInt(-2147474172);
            message.value.write2Bytes(bb);
            message.mask.write2Bytes(bb);
        }
    }

    static class OFOxmSctpDstMaskedVer13Funnel
    implements Funnel<OFOxmSctpDstMaskedVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmSctpDstMaskedVer13Funnel() {
        }

        public void funnel(OFOxmSctpDstMaskedVer13 message, PrimitiveSink sink) {
            sink.putInt(-2147474172);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmSctpDstMasked> {
        Reader() {
        }

        @Override
        public OFOxmSctpDstMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147474172) {
                throw new OFParseError("Wrong typeLen: Expected=0x80002504L(0x80002504L), got=" + typeLen);
            }
            TransportPort value = TransportPort.read2Bytes(bb);
            TransportPort mask = TransportPort.read2Bytes(bb);
            OFOxmSctpDstMaskedVer13 oxmSctpDstMaskedVer13 = new OFOxmSctpDstMaskedVer13(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmSctpDstMaskedVer13);
            }
            return oxmSctpDstMaskedVer13;
        }
    }

    static class Builder
    implements OFOxmSctpDstMasked.Builder {
        private boolean valueSet;
        private TransportPort value;
        private boolean maskSet;
        private TransportPort mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147493124L;
        }

        @Override
        public TransportPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmSctpDstMasked.Builder setValue(TransportPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public TransportPort getMask() {
            return this.mask;
        }

        @Override
        public OFOxmSctpDstMasked.Builder setMask(TransportPort mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<TransportPort> getMatchField() {
            return MatchField.SCTP_DST;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<TransportPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmSctpDstMasked build() {
            TransportPort mask;
            TransportPort value;
            TransportPort transportPort = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            TransportPort transportPort2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmSctpDstMaskedVer13(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmSctpDstMasked.Builder {
        final OFOxmSctpDstMaskedVer13 parentMessage;
        private boolean valueSet;
        private TransportPort value;
        private boolean maskSet;
        private TransportPort mask;

        BuilderWithParent(OFOxmSctpDstMaskedVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147493124L;
        }

        @Override
        public TransportPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmSctpDstMasked.Builder setValue(TransportPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public TransportPort getMask() {
            return this.mask;
        }

        @Override
        public OFOxmSctpDstMasked.Builder setMask(TransportPort mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<TransportPort> getMatchField() {
            return MatchField.SCTP_DST;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<TransportPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmSctpDstMasked build() {
            TransportPort mask;
            TransportPort value;
            TransportPort transportPort = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            TransportPort transportPort2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmSctpDstMaskedVer13(value, mask);
        }
    }
}

