/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvVlanVidMask;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvVlanVidMaskVer13
implements OFBsnTlvVlanVidMask {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvVlanVidMaskVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private static final int DEFAULT_VALUE = 0;
    private final int value;
    static final OFBsnTlvVlanVidMaskVer13 DEFAULT = new OFBsnTlvVlanVidMaskVer13(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvVlanVidMaskVer13Funnel FUNNEL = new OFBsnTlvVlanVidMaskVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvVlanVidMaskVer13(int value) {
        this.value = U16.normalize(value);
    }

    @Override
    public int getType() {
        return 77;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvVlanVidMask.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvVlanVidMaskVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvVlanVidMaskVer13 other = (OFBsnTlvVlanVidMaskVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvVlanVidMaskVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvVlanVidMaskVer13 message) {
            bb.writeShort(77);
            bb.writeShort(6);
            bb.writeShort((int)U16.t(message.value));
        }
    }

    static class OFBsnTlvVlanVidMaskVer13Funnel
    implements Funnel<OFBsnTlvVlanVidMaskVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvVlanVidMaskVer13Funnel() {
        }

        public void funnel(OFBsnTlvVlanVidMaskVer13 message, PrimitiveSink sink) {
            sink.putShort((short)77);
            sink.putShort((short)6);
            sink.putInt(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvVlanVidMask> {
        Reader() {
        }

        @Override
        public OFBsnTlvVlanVidMask readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 77) {
                throw new OFParseError("Wrong type: Expected=0x4d(0x4d), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int value = U16.f(bb.readShort());
            OFBsnTlvVlanVidMaskVer13 bsnTlvVlanVidMaskVer13 = new OFBsnTlvVlanVidMaskVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvVlanVidMaskVer13);
            }
            return bsnTlvVlanVidMaskVer13;
        }
    }

    static class Builder
    implements OFBsnTlvVlanVidMask.Builder {
        private boolean valueSet;
        private int value;

        Builder() {
        }

        @Override
        public int getType() {
            return 77;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvVlanVidMask.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvVlanVidMask build() {
            int value = this.valueSet ? this.value : 0;
            return new OFBsnTlvVlanVidMaskVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvVlanVidMask.Builder {
        final OFBsnTlvVlanVidMaskVer13 parentMessage;
        private boolean valueSet;
        private int value;

        BuilderWithParent(OFBsnTlvVlanVidMaskVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 77;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvVlanVidMask.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvVlanVidMask build() {
            int value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvVlanVidMaskVer13(value);
        }
    }
}

