/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvUint64List;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvUint64ListVer13
implements OFBsnTlvUint64List {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvUint64ListVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 4;
    static final int MAXIMUM_LENGTH = 65535;
    private static final List<U64> DEFAULT_VALUE = ImmutableList.of();
    private final List<U64> value;
    static final OFBsnTlvUint64ListVer13 DEFAULT = new OFBsnTlvUint64ListVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvUint64ListVer13Funnel FUNNEL = new OFBsnTlvUint64ListVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvUint64ListVer13(List<U64> value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvUint64ListVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 119;
    }

    @Override
    public List<U64> getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvUint64List.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvUint64ListVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvUint64ListVer13 other = (OFBsnTlvUint64ListVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvUint64ListVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvUint64ListVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(119);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            ChannelUtils.writeList(bb, message.value);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFBsnTlvUint64ListVer13: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnTlvUint64ListVer13Funnel
    implements Funnel<OFBsnTlvUint64ListVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvUint64ListVer13Funnel() {
        }

        public void funnel(OFBsnTlvUint64ListVer13 message, PrimitiveSink sink) {
            sink.putShort((short)119);
            FunnelUtils.putList(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvUint64List> {
        Reader() {
        }

        @Override
        public OFBsnTlvUint64List readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 119) {
                throw new OFParseError("Wrong type: Expected=0x77(0x77), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            List<U64> value = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), U64.READER);
            OFBsnTlvUint64ListVer13 bsnTlvUint64ListVer13 = new OFBsnTlvUint64ListVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvUint64ListVer13);
            }
            return bsnTlvUint64ListVer13;
        }
    }

    static class Builder
    implements OFBsnTlvUint64List.Builder {
        private boolean valueSet;
        private List<U64> value;

        Builder() {
        }

        @Override
        public int getType() {
            return 119;
        }

        @Override
        public List<U64> getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUint64List.Builder setValue(List<U64> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvUint64List build() {
            List<U64> value;
            List<U64> list = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvUint64ListVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvUint64List.Builder {
        final OFBsnTlvUint64ListVer13 parentMessage;
        private boolean valueSet;
        private List<U64> value;

        BuilderWithParent(OFBsnTlvUint64ListVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 119;
        }

        @Override
        public List<U64> getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUint64List.Builder setValue(List<U64> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvUint64List build() {
            List value;
            List list = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvUint64ListVer13(value);
        }
    }
}

