/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnUdfMode;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvUdfCapability;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnUdfModeSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvUdfCapabilityVer13
implements OFBsnTlvUdfCapability {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvUdfCapabilityVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 5;
    private static final Set<OFBsnUdfMode> DEFAULT_VALUE = ImmutableSet.of();
    private final Set<OFBsnUdfMode> value;
    static final OFBsnTlvUdfCapabilityVer13 DEFAULT = new OFBsnTlvUdfCapabilityVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvUdfCapabilityVer13Funnel FUNNEL = new OFBsnTlvUdfCapabilityVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvUdfCapabilityVer13(Set<OFBsnUdfMode> value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvUdfCapabilityVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 180;
    }

    @Override
    public Set<OFBsnUdfMode> getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvUdfCapability.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvUdfCapabilityVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvUdfCapabilityVer13 other = (OFBsnTlvUdfCapabilityVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvUdfCapabilityVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvUdfCapabilityVer13 message) {
            bb.writeShort(180);
            bb.writeShort(5);
            OFBsnUdfModeSerializerVer13.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvUdfCapabilityVer13Funnel
    implements Funnel<OFBsnTlvUdfCapabilityVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvUdfCapabilityVer13Funnel() {
        }

        public void funnel(OFBsnTlvUdfCapabilityVer13 message, PrimitiveSink sink) {
            sink.putShort((short)180);
            sink.putShort((short)5);
            OFBsnUdfModeSerializerVer13.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvUdfCapability> {
        Reader() {
        }

        @Override
        public OFBsnTlvUdfCapability readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 180) {
                throw new OFParseError("Wrong type: Expected=0xb4(0xb4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            Set<OFBsnUdfMode> value = OFBsnUdfModeSerializerVer13.readFrom(bb);
            OFBsnTlvUdfCapabilityVer13 bsnTlvUdfCapabilityVer13 = new OFBsnTlvUdfCapabilityVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvUdfCapabilityVer13);
            }
            return bsnTlvUdfCapabilityVer13;
        }
    }

    static class Builder
    implements OFBsnTlvUdfCapability.Builder {
        private boolean valueSet;
        private Set<OFBsnUdfMode> value;

        Builder() {
        }

        @Override
        public int getType() {
            return 180;
        }

        @Override
        public Set<OFBsnUdfMode> getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUdfCapability.Builder setValue(Set<OFBsnUdfMode> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvUdfCapability build() {
            Set<OFBsnUdfMode> value;
            Set<OFBsnUdfMode> set = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvUdfCapabilityVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvUdfCapability.Builder {
        final OFBsnTlvUdfCapabilityVer13 parentMessage;
        private boolean valueSet;
        private Set<OFBsnUdfMode> value;

        BuilderWithParent(OFBsnTlvUdfCapabilityVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 180;
        }

        @Override
        public Set<OFBsnUdfMode> getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUdfCapability.Builder setValue(Set<OFBsnUdfMode> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvUdfCapability build() {
            Set value;
            Set set = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvUdfCapabilityVer13(value);
        }
    }
}

