/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvTtl;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvTtlVer13
implements OFBsnTlvTtl {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvTtlVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private static final int DEFAULT_VALUE = 0;
    private final int value;
    static final OFBsnTlvTtlVer13 DEFAULT = new OFBsnTlvTtlVer13(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvTtlVer13Funnel FUNNEL = new OFBsnTlvTtlVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvTtlVer13(int value) {
        this.value = U16.normalize(value);
    }

    @Override
    public int getType() {
        return 113;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvTtl.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvTtlVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvTtlVer13 other = (OFBsnTlvTtlVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvTtlVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvTtlVer13 message) {
            bb.writeShort(113);
            bb.writeShort(6);
            bb.writeShort((int)U16.t(message.value));
        }
    }

    static class OFBsnTlvTtlVer13Funnel
    implements Funnel<OFBsnTlvTtlVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvTtlVer13Funnel() {
        }

        public void funnel(OFBsnTlvTtlVer13 message, PrimitiveSink sink) {
            sink.putShort((short)113);
            sink.putShort((short)6);
            sink.putInt(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvTtl> {
        Reader() {
        }

        @Override
        public OFBsnTlvTtl readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 113) {
                throw new OFParseError("Wrong type: Expected=0x71(0x71), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int value = U16.f(bb.readShort());
            OFBsnTlvTtlVer13 bsnTlvTtlVer13 = new OFBsnTlvTtlVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvTtlVer13);
            }
            return bsnTlvTtlVer13;
        }
    }

    static class Builder
    implements OFBsnTlvTtl.Builder {
        private boolean valueSet;
        private int value;

        Builder() {
        }

        @Override
        public int getType() {
            return 113;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvTtl.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvTtl build() {
            int value = this.valueSet ? this.value : 0;
            return new OFBsnTlvTtlVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvTtl.Builder {
        final OFBsnTlvTtlVer13 parentMessage;
        private boolean valueSet;
        private int value;

        BuilderWithParent(OFBsnTlvTtlVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 113;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvTtl.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvTtl build() {
            int value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvTtlVer13(value);
        }
    }
}

