/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnGentableEntryAdd;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlv;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnTlvVer13;
import org.projectfloodlight.openflow.types.GenTableId;
import org.projectfloodlight.openflow.types.U128;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnGentableEntryAddVer13
implements OFBsnGentableEntryAdd {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnGentableEntryAddVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 36;
    static final int MAXIMUM_LENGTH = 65535;
    private static final long DEFAULT_XID = 0L;
    private static final U128 DEFAULT_CHECKSUM = U128.ZERO;
    private static final List<OFBsnTlv> DEFAULT_KEY = ImmutableList.of();
    private static final List<OFBsnTlv> DEFAULT_VALUE = ImmutableList.of();
    private final long xid;
    private final GenTableId tableId;
    private final U128 checksum;
    private final List<OFBsnTlv> key;
    private final List<OFBsnTlv> value;
    static final Reader READER = new Reader();
    static final OFBsnGentableEntryAddVer13Funnel FUNNEL = new OFBsnGentableEntryAddVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnGentableEntryAddVer13(long xid, GenTableId tableId, U128 checksum, List<OFBsnTlv> key, List<OFBsnTlv> value) {
        if (tableId == null) {
            throw new NullPointerException("OFBsnGentableEntryAddVer13: property tableId cannot be null");
        }
        if (checksum == null) {
            throw new NullPointerException("OFBsnGentableEntryAddVer13: property checksum cannot be null");
        }
        if (key == null) {
            throw new NullPointerException("OFBsnGentableEntryAddVer13: property key cannot be null");
        }
        if (value == null) {
            throw new NullPointerException("OFBsnGentableEntryAddVer13: property value cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.tableId = tableId;
        this.checksum = checksum;
        this.key = key;
        this.value = value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 46L;
    }

    @Override
    public GenTableId getTableId() {
        return this.tableId;
    }

    @Override
    public U128 getChecksum() {
        return this.checksum;
    }

    @Override
    public List<OFBsnTlv> getKey() {
        return this.key;
    }

    @Override
    public List<OFBsnTlv> getValue() {
        return this.value;
    }

    @Override
    public OFBsnGentableEntryAdd.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnGentableEntryAddVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("checksum=").append(this.checksum);
        b.append(", ");
        b.append("key=").append(this.key);
        b.append(", ");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGentableEntryAddVer13 other = (OFBsnGentableEntryAddVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.checksum == null ? other.checksum != null : !this.checksum.equals(other.checksum)) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGentableEntryAddVer13 other = (OFBsnGentableEntryAddVer13)obj;
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.checksum == null ? other.checksum != null : !this.checksum.equals(other.checksum)) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + (this.checksum == null ? 0 : this.checksum.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + (this.checksum == null ? 0 : this.checksum.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnGentableEntryAddVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnGentableEntryAddVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(4);
            bb.writeByte(4);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(46);
            message.tableId.write2Bytes(bb);
            int keyLengthIndex = bb.writerIndex();
            bb.writeShort(0);
            message.checksum.write16Bytes(bb);
            int keyStartIndex = bb.writerIndex();
            ChannelUtils.writeList(bb, message.key);
            int keyLength = bb.writerIndex() - keyStartIndex;
            bb.setShort(keyLengthIndex, keyLength);
            ChannelUtils.writeList(bb, message.value);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFBsnGentableEntryAddVer13: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnGentableEntryAddVer13Funnel
    implements Funnel<OFBsnGentableEntryAddVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnGentableEntryAddVer13Funnel() {
        }

        public void funnel(OFBsnGentableEntryAddVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)4);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(46);
            message.tableId.putTo(sink);
            message.checksum.putTo(sink);
            FunnelUtils.putList(message.key, sink);
            FunnelUtils.putList(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnGentableEntryAdd> {
        Reader() {
        }

        @Override
        public OFBsnGentableEntryAdd readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 36) {
                throw new OFParseError("Wrong length: Expected to be >= 36, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 46) {
                throw new OFParseError("Wrong subtype: Expected=0x2eL(0x2eL), got=" + subtype);
            }
            GenTableId tableId = GenTableId.read2Bytes(bb);
            int keyLength = U16.f(bb.readShort());
            U128 checksum = U128.read16Bytes(bb);
            List<OFBsnTlv> key = ChannelUtils.readList(bb, keyLength, OFBsnTlvVer13.READER);
            List<OFBsnTlv> value = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFBsnTlvVer13.READER);
            OFBsnGentableEntryAddVer13 bsnGentableEntryAddVer13 = new OFBsnGentableEntryAddVer13(xid, tableId, checksum, key, value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnGentableEntryAddVer13);
            }
            return bsnGentableEntryAddVer13;
        }
    }

    static class Builder
    implements OFBsnGentableEntryAdd.Builder {
        private boolean xidSet;
        private long xid;
        private boolean tableIdSet;
        private GenTableId tableId;
        private boolean checksumSet;
        private U128 checksum;
        private boolean keySet;
        private List<OFBsnTlv> key;
        private boolean valueSet;
        private List<OFBsnTlv> value;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGentableEntryAdd.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 46L;
        }

        @Override
        public GenTableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFBsnGentableEntryAdd.Builder setTableId(GenTableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public U128 getChecksum() {
            return this.checksum;
        }

        @Override
        public OFBsnGentableEntryAdd.Builder setChecksum(U128 checksum) {
            this.checksum = checksum;
            this.checksumSet = true;
            return this;
        }

        @Override
        public List<OFBsnTlv> getKey() {
            return this.key;
        }

        @Override
        public OFBsnGentableEntryAdd.Builder setKey(List<OFBsnTlv> key) {
            this.key = key;
            this.keySet = true;
            return this;
        }

        @Override
        public List<OFBsnTlv> getValue() {
            return this.value;
        }

        @Override
        public OFBsnGentableEntryAdd.Builder setValue(List<OFBsnTlv> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFBsnGentableEntryAdd build() {
            List<OFBsnTlv> value;
            List<OFBsnTlv> key;
            U128 checksum;
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.tableIdSet) {
                throw new IllegalStateException("Property tableId doesn't have default value -- must be set");
            }
            if (this.tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            U128 u128 = checksum = this.checksumSet ? this.checksum : DEFAULT_CHECKSUM;
            if (checksum == null) {
                throw new NullPointerException("Property checksum must not be null");
            }
            List<OFBsnTlv> list = key = this.keySet ? this.key : DEFAULT_KEY;
            if (key == null) {
                throw new NullPointerException("Property key must not be null");
            }
            List<OFBsnTlv> list2 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnGentableEntryAddVer13(xid, this.tableId, checksum, key, value);
        }
    }

    static class BuilderWithParent
    implements OFBsnGentableEntryAdd.Builder {
        final OFBsnGentableEntryAddVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean tableIdSet;
        private GenTableId tableId;
        private boolean checksumSet;
        private U128 checksum;
        private boolean keySet;
        private List<OFBsnTlv> key;
        private boolean valueSet;
        private List<OFBsnTlv> value;

        BuilderWithParent(OFBsnGentableEntryAddVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGentableEntryAdd.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 46L;
        }

        @Override
        public GenTableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFBsnGentableEntryAdd.Builder setTableId(GenTableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public U128 getChecksum() {
            return this.checksum;
        }

        @Override
        public OFBsnGentableEntryAdd.Builder setChecksum(U128 checksum) {
            this.checksum = checksum;
            this.checksumSet = true;
            return this;
        }

        @Override
        public List<OFBsnTlv> getKey() {
            return this.key;
        }

        @Override
        public OFBsnGentableEntryAdd.Builder setKey(List<OFBsnTlv> key) {
            this.key = key;
            this.keySet = true;
            return this;
        }

        @Override
        public List<OFBsnTlv> getValue() {
            return this.value;
        }

        @Override
        public OFBsnGentableEntryAdd.Builder setValue(List<OFBsnTlv> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFBsnGentableEntryAdd build() {
            List value;
            List key;
            U128 checksum;
            GenTableId tableId;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            GenTableId genTableId = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            U128 u128 = checksum = this.checksumSet ? this.checksum : this.parentMessage.checksum;
            if (checksum == null) {
                throw new NullPointerException("Property checksum must not be null");
            }
            List list = key = this.keySet ? this.key : this.parentMessage.key;
            if (key == null) {
                throw new NullPointerException("Property key must not be null");
            }
            List list2 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnGentableEntryAddVer13(xid, tableId, checksum, key, value);
        }
    }
}

