/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionSetNwTtl;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionSetNwTtlVer13
implements OFActionSetNwTtl {
    private static final Logger logger = LoggerFactory.getLogger(OFActionSetNwTtlVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final short DEFAULT_NW_TTL = 0;
    private final short nwTtl;
    static final OFActionSetNwTtlVer13 DEFAULT = new OFActionSetNwTtlVer13(0);
    static final Reader READER = new Reader();
    static final OFActionSetNwTtlVer13Funnel FUNNEL = new OFActionSetNwTtlVer13Funnel();
    static final Writer WRITER = new Writer();

    OFActionSetNwTtlVer13(short nwTtl) {
        this.nwTtl = U8.normalize(nwTtl);
    }

    @Override
    public OFActionType getType() {
        return OFActionType.SET_NW_TTL;
    }

    @Override
    public short getNwTtl() {
        return this.nwTtl;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFActionSetNwTtl.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionSetNwTtlVer13(");
        b.append("nwTtl=").append(this.nwTtl);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionSetNwTtlVer13 other = (OFActionSetNwTtlVer13)obj;
        return this.nwTtl == other.nwTtl;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.nwTtl;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionSetNwTtlVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionSetNwTtlVer13 message) {
            bb.writeShort(23);
            bb.writeShort(8);
            bb.writeByte((int)U8.t(message.nwTtl));
            bb.writeZero(3);
        }
    }

    static class OFActionSetNwTtlVer13Funnel
    implements Funnel<OFActionSetNwTtlVer13> {
        private static final long serialVersionUID = 1L;

        OFActionSetNwTtlVer13Funnel() {
        }

        public void funnel(OFActionSetNwTtlVer13 message, PrimitiveSink sink) {
            sink.putShort((short)23);
            sink.putShort((short)8);
            sink.putShort(message.nwTtl);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionSetNwTtl> {
        Reader() {
        }

        @Override
        public OFActionSetNwTtl readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 23) {
                throw new OFParseError("Wrong type: Expected=OFActionType.SET_NW_TTL(23), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            short nwTtl = U8.f(bb.readByte());
            bb.skipBytes(3);
            OFActionSetNwTtlVer13 actionSetNwTtlVer13 = new OFActionSetNwTtlVer13(nwTtl);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionSetNwTtlVer13);
            }
            return actionSetNwTtlVer13;
        }
    }

    static class Builder
    implements OFActionSetNwTtl.Builder {
        private boolean nwTtlSet;
        private short nwTtl;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_NW_TTL;
        }

        @Override
        public short getNwTtl() {
            return this.nwTtl;
        }

        @Override
        public OFActionSetNwTtl.Builder setNwTtl(short nwTtl) {
            this.nwTtl = nwTtl;
            this.nwTtlSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFActionSetNwTtl build() {
            short nwTtl = this.nwTtlSet ? this.nwTtl : (short)0;
            return new OFActionSetNwTtlVer13(nwTtl);
        }
    }

    static class BuilderWithParent
    implements OFActionSetNwTtl.Builder {
        final OFActionSetNwTtlVer13 parentMessage;
        private boolean nwTtlSet;
        private short nwTtl;

        BuilderWithParent(OFActionSetNwTtlVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_NW_TTL;
        }

        @Override
        public short getNwTtl() {
            return this.nwTtl;
        }

        @Override
        public OFActionSetNwTtl.Builder setNwTtl(short nwTtl) {
            this.nwTtl = nwTtl;
            this.nwTtlSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFActionSetNwTtl build() {
            short nwTtl = this.nwTtlSet ? this.nwTtl : this.parentMessage.nwTtl;
            return new OFActionSetNwTtlVer13(nwTtl);
        }
    }
}

