/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionDecMplsTtl;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionDecMplsTtlVer13
implements OFActionDecMplsTtl {
    private static final Logger logger = LoggerFactory.getLogger(OFActionDecMplsTtlVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    static final OFActionDecMplsTtlVer13 DEFAULT = new OFActionDecMplsTtlVer13();
    static final OFActionDecMplsTtlVer13 INSTANCE = new OFActionDecMplsTtlVer13();
    static final Reader READER = new Reader();
    static final OFActionDecMplsTtlVer13Funnel FUNNEL = new OFActionDecMplsTtlVer13Funnel();
    static final Writer WRITER = new Writer();

    private OFActionDecMplsTtlVer13() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.DEC_MPLS_TTL;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFActionDecMplsTtl.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionDecMplsTtlVer13 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionDecMplsTtlVer13(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionDecMplsTtlVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionDecMplsTtlVer13 message) {
            bb.writeShort(16);
            bb.writeShort(8);
            bb.writeZero(4);
        }
    }

    static class OFActionDecMplsTtlVer13Funnel
    implements Funnel<OFActionDecMplsTtlVer13> {
        private static final long serialVersionUID = 1L;

        OFActionDecMplsTtlVer13Funnel() {
        }

        public void funnel(OFActionDecMplsTtlVer13 message, PrimitiveSink sink) {
            sink.putShort((short)16);
            sink.putShort((short)8);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionDecMplsTtl> {
        Reader() {
        }

        @Override
        public OFActionDecMplsTtl readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 16) {
                throw new OFParseError("Wrong type: Expected=OFActionType.DEC_MPLS_TTL(16), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(4);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

