/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmMplsTc;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmMplsTcVer12
implements OFOxmMplsTc {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmMplsTcVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 5;
    private static final U8 DEFAULT_VALUE = U8.ZERO;
    private final U8 value;
    static final OFOxmMplsTcVer12 DEFAULT = new OFOxmMplsTcVer12(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmMplsTcVer12Funnel FUNNEL = new OFOxmMplsTcVer12Funnel();
    static final Writer WRITER = new Writer();

    OFOxmMplsTcVer12(U8 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmMplsTcVer12: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147501569L;
    }

    @Override
    public U8 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U8> getMatchField() {
        return MatchField.MPLS_TC;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U8> getCanonical() {
        return this;
    }

    @Override
    public U8 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.2");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFOxmMplsTc.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmMplsTcVer12(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmMplsTcVer12 other = (OFOxmMplsTcVer12)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmMplsTcVer12> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmMplsTcVer12 message) {
            bb.writeInt(-2147465727);
            bb.writeByte((int)message.value.getRaw());
        }
    }

    static class OFOxmMplsTcVer12Funnel
    implements Funnel<OFOxmMplsTcVer12> {
        private static final long serialVersionUID = 1L;

        OFOxmMplsTcVer12Funnel() {
        }

        public void funnel(OFOxmMplsTcVer12 message, PrimitiveSink sink) {
            sink.putInt(-2147465727);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmMplsTc> {
        Reader() {
        }

        @Override
        public OFOxmMplsTc readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147465727) {
                throw new OFParseError("Wrong typeLen: Expected=0x80004601L(0x80004601L), got=" + typeLen);
            }
            U8 value = U8.of(bb.readByte());
            OFOxmMplsTcVer12 oxmMplsTcVer12 = new OFOxmMplsTcVer12(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmMplsTcVer12);
            }
            return oxmMplsTcVer12;
        }
    }

    static class Builder
    implements OFOxmMplsTc.Builder {
        private boolean valueSet;
        private U8 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147501569L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmMplsTc.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.MPLS_TC;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public U8 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmMplsTc build() {
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmMplsTcVer12(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmMplsTc.Builder {
        final OFOxmMplsTcVer12 parentMessage;
        private boolean valueSet;
        private U8 value;

        BuilderWithParent(OFOxmMplsTcVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147501569L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmMplsTc.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.MPLS_TC;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public U8 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmMplsTc build() {
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmMplsTcVer12(value);
        }
    }
}

