/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnUdf2;
import org.projectfloodlight.openflow.types.UDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnUdf2Ver12
implements OFOxmBsnUdf2 {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnUdf2Ver12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 8;
    private static final UDF DEFAULT_VALUE = UDF.ZERO;
    private final UDF value;
    static final OFOxmBsnUdf2Ver12 DEFAULT = new OFOxmBsnUdf2Ver12(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmBsnUdf2Ver12Funnel FUNNEL = new OFOxmBsnUdf2Ver12Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnUdf2Ver12(UDF value) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnUdf2Ver12: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 201732L;
    }

    @Override
    public UDF getValue() {
        return this.value;
    }

    @Override
    public MatchField<UDF> getMatchField() {
        return MatchField.BSN_UDF2;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<UDF> getCanonical() {
        return this;
    }

    @Override
    public UDF getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.2");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFOxmBsnUdf2.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnUdf2Ver12(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnUdf2Ver12 other = (OFOxmBsnUdf2Ver12)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnUdf2Ver12> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnUdf2Ver12 message) {
            bb.writeInt(201732);
            message.value.write4Bytes(bb);
        }
    }

    static class OFOxmBsnUdf2Ver12Funnel
    implements Funnel<OFOxmBsnUdf2Ver12> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnUdf2Ver12Funnel() {
        }

        public void funnel(OFOxmBsnUdf2Ver12 message, PrimitiveSink sink) {
            sink.putInt(201732);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnUdf2> {
        Reader() {
        }

        @Override
        public OFOxmBsnUdf2 readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 201732) {
                throw new OFParseError("Wrong typeLen: Expected=0x31404L(0x31404L), got=" + typeLen);
            }
            UDF value = UDF.read4Bytes(bb);
            OFOxmBsnUdf2Ver12 oxmBsnUdf2Ver12 = new OFOxmBsnUdf2Ver12(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnUdf2Ver12);
            }
            return oxmBsnUdf2Ver12;
        }
    }

    static class Builder
    implements OFOxmBsnUdf2.Builder {
        private boolean valueSet;
        private UDF value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 201732L;
        }

        @Override
        public UDF getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnUdf2.Builder setValue(UDF value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<UDF> getMatchField() {
            return MatchField.BSN_UDF2;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<UDF> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public UDF getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmBsnUdf2 build() {
            UDF value;
            UDF uDF = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnUdf2Ver12(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnUdf2.Builder {
        final OFOxmBsnUdf2Ver12 parentMessage;
        private boolean valueSet;
        private UDF value;

        BuilderWithParent(OFOxmBsnUdf2Ver12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 201732L;
        }

        @Override
        public UDF getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnUdf2.Builder setValue(UDF value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<UDF> getMatchField() {
            return MatchField.BSN_UDF2;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<UDF> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public UDF getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmBsnUdf2 build() {
            UDF value;
            UDF uDF = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmBsnUdf2Ver12(value);
        }
    }
}

