/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFStatsType;

public class OFStatsTypeSerializerVer11 {
    public static final short DESC_VAL = 0;
    public static final short FLOW_VAL = 1;
    public static final short AGGREGATE_VAL = 2;
    public static final short TABLE_VAL = 3;
    public static final short PORT_VAL = 4;
    public static final short QUEUE_VAL = 5;
    public static final short GROUP_VAL = 6;
    public static final short GROUP_DESC_VAL = 7;
    public static final short EXPERIMENTER_VAL = -1;

    public static OFStatsType readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFStatsTypeSerializerVer11.ofWireValue(bb.readShort());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, OFStatsType e) {
        bb.writeShort((int)OFStatsTypeSerializerVer11.toWireValue(e));
    }

    public static void putTo(OFStatsType e, PrimitiveSink sink) {
        sink.putShort(OFStatsTypeSerializerVer11.toWireValue(e));
    }

    public static OFStatsType ofWireValue(short val) {
        switch (val) {
            case 0: {
                return OFStatsType.DESC;
            }
            case 1: {
                return OFStatsType.FLOW;
            }
            case 2: {
                return OFStatsType.AGGREGATE;
            }
            case 3: {
                return OFStatsType.TABLE;
            }
            case 4: {
                return OFStatsType.PORT;
            }
            case 5: {
                return OFStatsType.QUEUE;
            }
            case 6: {
                return OFStatsType.GROUP;
            }
            case 7: {
                return OFStatsType.GROUP_DESC;
            }
            case -1: {
                return OFStatsType.EXPERIMENTER;
            }
        }
        throw new IllegalArgumentException("Illegal wire value for type OFStatsType in version 1.1: " + val);
    }

    public static short toWireValue(OFStatsType e) {
        switch (e) {
            case DESC: {
                return 0;
            }
            case FLOW: {
                return 1;
            }
            case AGGREGATE: {
                return 2;
            }
            case TABLE: {
                return 3;
            }
            case PORT: {
                return 4;
            }
            case QUEUE: {
                return 5;
            }
            case GROUP: {
                return 6;
            }
            case GROUP_DESC: {
                return 7;
            }
            case EXPERIMENTER: {
                return -1;
            }
        }
        throw new IllegalArgumentException("Illegal enum value for type OFStatsType in version 1.1: " + (Object)((Object)e));
    }
}

