/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionSetMplsTc;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionSetMplsTcVer11
implements OFActionSetMplsTc {
    private static final Logger logger = LoggerFactory.getLogger(OFActionSetMplsTcVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 8;
    private static final short DEFAULT_MPLS_TC = 0;
    private final short mplsTc;
    static final OFActionSetMplsTcVer11 DEFAULT = new OFActionSetMplsTcVer11(0);
    static final Reader READER = new Reader();
    static final OFActionSetMplsTcVer11Funnel FUNNEL = new OFActionSetMplsTcVer11Funnel();
    static final Writer WRITER = new Writer();

    OFActionSetMplsTcVer11(short mplsTc) {
        this.mplsTc = U8.normalize(mplsTc);
    }

    @Override
    public OFActionType getType() {
        return OFActionType.SET_MPLS_TC;
    }

    @Override
    public short getMplsTc() {
        return this.mplsTc;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFActionSetMplsTc.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionSetMplsTcVer11(");
        b.append("mplsTc=").append(this.mplsTc);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionSetMplsTcVer11 other = (OFActionSetMplsTcVer11)obj;
        return this.mplsTc == other.mplsTc;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mplsTc;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionSetMplsTcVer11> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionSetMplsTcVer11 message) {
            bb.writeShort(14);
            bb.writeShort(8);
            bb.writeByte((int)U8.t(message.mplsTc));
            bb.writeZero(3);
        }
    }

    static class OFActionSetMplsTcVer11Funnel
    implements Funnel<OFActionSetMplsTcVer11> {
        private static final long serialVersionUID = 1L;

        OFActionSetMplsTcVer11Funnel() {
        }

        public void funnel(OFActionSetMplsTcVer11 message, PrimitiveSink sink) {
            sink.putShort((short)14);
            sink.putShort((short)8);
            sink.putShort(message.mplsTc);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionSetMplsTc> {
        Reader() {
        }

        @Override
        public OFActionSetMplsTc readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 14) {
                throw new OFParseError("Wrong type: Expected=OFActionType.SET_MPLS_TC(14), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            short mplsTc = U8.f(bb.readByte());
            bb.skipBytes(3);
            OFActionSetMplsTcVer11 actionSetMplsTcVer11 = new OFActionSetMplsTcVer11(mplsTc);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionSetMplsTcVer11);
            }
            return actionSetMplsTcVer11;
        }
    }

    static class Builder
    implements OFActionSetMplsTc.Builder {
        private boolean mplsTcSet;
        private short mplsTc;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_MPLS_TC;
        }

        @Override
        public short getMplsTc() {
            return this.mplsTc;
        }

        @Override
        public OFActionSetMplsTc.Builder setMplsTc(short mplsTc) {
            this.mplsTc = mplsTc;
            this.mplsTcSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFActionSetMplsTc build() {
            short mplsTc = this.mplsTcSet ? this.mplsTc : (short)0;
            return new OFActionSetMplsTcVer11(mplsTc);
        }
    }

    static class BuilderWithParent
    implements OFActionSetMplsTc.Builder {
        final OFActionSetMplsTcVer11 parentMessage;
        private boolean mplsTcSet;
        private short mplsTc;

        BuilderWithParent(OFActionSetMplsTcVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_MPLS_TC;
        }

        @Override
        public short getMplsTc() {
            return this.mplsTc;
        }

        @Override
        public OFActionSetMplsTc.Builder setMplsTc(short mplsTc) {
            this.mplsTc = mplsTc;
            this.mplsTcSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFActionSetMplsTc build() {
            short mplsTc = this.mplsTcSet ? this.mplsTc : this.parentMessage.mplsTc;
            return new OFActionSetMplsTcVer11(mplsTc);
        }
    }
}

