/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionEnqueue;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionEnqueueVer10
implements OFActionEnqueue {
    private static final Logger logger = LoggerFactory.getLogger(OFActionEnqueueVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int LENGTH = 16;
    private static final OFPort DEFAULT_PORT = OFPort.ANY;
    private static final long DEFAULT_QUEUE_ID = 0L;
    private final OFPort port;
    private final long queueId;
    static final OFActionEnqueueVer10 DEFAULT = new OFActionEnqueueVer10(DEFAULT_PORT, 0L);
    static final Reader READER = new Reader();
    static final OFActionEnqueueVer10Funnel FUNNEL = new OFActionEnqueueVer10Funnel();
    static final Writer WRITER = new Writer();

    OFActionEnqueueVer10(OFPort port, long queueId) {
        if (port == null) {
            throw new NullPointerException("OFActionEnqueueVer10: property port cannot be null");
        }
        this.port = port;
        this.queueId = U32.normalize(queueId);
    }

    @Override
    public OFActionType getType() {
        return OFActionType.ENQUEUE;
    }

    @Override
    public OFPort getPort() {
        return this.port;
    }

    @Override
    public long getQueueId() {
        return this.queueId;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public OFActionEnqueue.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionEnqueueVer10(");
        b.append("port=").append(this.port);
        b.append(", ");
        b.append("queueId=").append(this.queueId);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionEnqueueVer10 other = (OFActionEnqueueVer10)obj;
        if (this.port == null ? other.port != null : !this.port.equals(other.port)) {
            return false;
        }
        return this.queueId == other.queueId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.port == null ? 0 : this.port.hashCode());
        result = 31 * (int)(this.queueId ^ this.queueId >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionEnqueueVer10> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionEnqueueVer10 message) {
            bb.writeShort(11);
            bb.writeShort(16);
            message.port.write2Bytes(bb);
            bb.writeZero(6);
            bb.writeInt(U32.t(message.queueId));
        }
    }

    static class OFActionEnqueueVer10Funnel
    implements Funnel<OFActionEnqueueVer10> {
        private static final long serialVersionUID = 1L;

        OFActionEnqueueVer10Funnel() {
        }

        public void funnel(OFActionEnqueueVer10 message, PrimitiveSink sink) {
            sink.putShort((short)11);
            sink.putShort((short)16);
            message.port.putTo(sink);
            sink.putLong(message.queueId);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionEnqueue> {
        Reader() {
        }

        @Override
        public OFActionEnqueue readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 11) {
                throw new OFParseError("Wrong type: Expected=OFActionType.ENQUEUE(11), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFPort port = OFPort.read2Bytes(bb);
            bb.skipBytes(6);
            long queueId = U32.f(bb.readInt());
            OFActionEnqueueVer10 actionEnqueueVer10 = new OFActionEnqueueVer10(port, queueId);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionEnqueueVer10);
            }
            return actionEnqueueVer10;
        }
    }

    static class Builder
    implements OFActionEnqueue.Builder {
        private boolean portSet;
        private OFPort port;
        private boolean queueIdSet;
        private long queueId;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.ENQUEUE;
        }

        @Override
        public OFPort getPort() {
            return this.port;
        }

        @Override
        public OFActionEnqueue.Builder setPort(OFPort port) {
            this.port = port;
            this.portSet = true;
            return this;
        }

        @Override
        public long getQueueId() {
            return this.queueId;
        }

        @Override
        public OFActionEnqueue.Builder setQueueId(long queueId) {
            this.queueId = queueId;
            this.queueIdSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFActionEnqueue build() {
            OFPort port;
            OFPort oFPort = port = this.portSet ? this.port : DEFAULT_PORT;
            if (port == null) {
                throw new NullPointerException("Property port must not be null");
            }
            long queueId = this.queueIdSet ? this.queueId : 0L;
            return new OFActionEnqueueVer10(port, queueId);
        }
    }

    static class BuilderWithParent
    implements OFActionEnqueue.Builder {
        final OFActionEnqueueVer10 parentMessage;
        private boolean portSet;
        private OFPort port;
        private boolean queueIdSet;
        private long queueId;

        BuilderWithParent(OFActionEnqueueVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.ENQUEUE;
        }

        @Override
        public OFPort getPort() {
            return this.port;
        }

        @Override
        public OFActionEnqueue.Builder setPort(OFPort port) {
            this.port = port;
            this.portSet = true;
            return this;
        }

        @Override
        public long getQueueId() {
            return this.queueId;
        }

        @Override
        public OFActionEnqueue.Builder setQueueId(long queueId) {
            this.queueId = queueId;
            this.queueIdSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFActionEnqueue build() {
            OFPort port;
            OFPort oFPort = port = this.portSet ? this.port : this.parentMessage.port;
            if (port == null) {
                throw new NullPointerException("Property port must not be null");
            }
            long queueId = this.queueIdSet ? this.queueId : this.parentMessage.queueId;
            return new OFActionEnqueueVer10(port, queueId);
        }
    }
}

