/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol;

import com.google.common.collect.ImmutableMap;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.Writeable;
import org.projectfloodlight.openflow.protocol.oxs.OFOxs;
import org.projectfloodlight.openflow.protocol.stat.StatField;
import org.projectfloodlight.openflow.protocol.stat.StatFields;
import org.projectfloodlight.openflow.types.OFValueType;
import org.projectfloodlight.openflow.types.PrimitiveSinkable;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OFOxsList
implements Iterable<OFOxs<?>>,
Writeable,
PrimitiveSinkable {
    private static final Logger logger = LoggerFactory.getLogger(OFOxsList.class);
    private final Map<StatFields, OFOxs<?>> oxsMap;
    public static final OFOxsList EMPTY = new OFOxsList((Map<StatFields, OFOxs<?>>)ImmutableMap.of());

    private OFOxsList(Map<StatFields, OFOxs<?>> oxsMap) {
        this.oxsMap = oxsMap;
    }

    public <T extends OFValueType<T>> OFOxs<T> get(StatField<T> statField) {
        return this.oxsMap.get((Object)statField.id);
    }

    @Override
    public Iterator<OFOxs<?>> iterator() {
        return this.oxsMap.values().iterator();
    }

    public static OFOxsList ofList(Iterable<OFOxs<?>> oxsList) {
        EnumMap map = new EnumMap(StatFields.class);
        for (OFOxs<?> o : oxsList) {
            map.put(o.getStatField().id, o);
        }
        return new OFOxsList(map);
    }

    public static OFOxsList of(OFOxs<?> ... oxss) {
        EnumMap map = new EnumMap(StatFields.class);
        for (OFOxs<?> o : oxss) {
            map.put(o.getStatField().id, o);
        }
        return new OFOxsList(map);
    }

    public static OFOxsList readFrom(ByteBuf bb, int length, OFMessageReader<OFOxs<?>> reader) throws OFParseError {
        return OFOxsList.ofList(ChannelUtils.readList(bb, length, reader));
    }

    @Override
    public void writeTo(ByteBuf bb) {
        for (OFOxs<?> o : this) {
            o.writeTo(bb);
        }
    }

    public Builder createBuilder() {
        return new Builder(new EnumMap(this.oxsMap));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.oxsMap == null ? 0 : this.oxsMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxsList other = (OFOxsList)obj;
        return !(this.oxsMap == null ? other.oxsMap != null : !this.oxsMap.equals(other.oxsMap));
    }

    public String toString() {
        return "OFOxsList" + this.oxsMap;
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        for (OFOxs<?> o : this) {
            o.putTo(sink);
        }
    }

    public static class Builder {
        private final Map<StatFields, OFOxs<?>> oxsMap;

        public Builder() {
            this.oxsMap = new EnumMap(StatFields.class);
        }

        public Builder(EnumMap<StatFields, OFOxs<?>> oxsMap) {
            this.oxsMap = oxsMap;
        }

        public <T extends OFValueType<T>> void set(OFOxs<T> oxs) {
            this.oxsMap.put(oxs.getStatField().id, oxs);
        }

        public <T extends OFValueType<T>> void unset(StatField<T> statField) {
            this.oxsMap.remove((Object)statField.id);
        }

        public OFOxsList build() {
            return OFOxsList.ofList(this.oxsMap.values());
        }
    }
}

