/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFPortConfig;
import org.projectfloodlight.openflow.protocol.OFPortReason;
import org.projectfloodlight.openflow.protocol.OFPortState;
import org.projectfloodlight.openflow.protocol.OFPortStatus;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFPortStatusVer15;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.OFPort;

public class OFPortStatusVer15Test {
    OFFactory factory;
    static final byte[] PORT_STATUS_SERIALIZED = new byte[]{6, 12, 0, 88, 18, 52, 86, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 72, 0, 0, 0, 0, 0, 18, 52, 86, 0, 0, 97, 98, 99, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 4, 0, 0, 0, 8, 0, 0, 0, 10, 0, 0, 0, 14};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFPortStatus.Builder builder = this.factory.buildPortStatus();
        builder.setXid(305419896L).setReason(OFPortReason.ADD).setDesc(this.factory.buildPortDesc().setPortNo(OFPort.ofInt((int)4)).setHwAddr(MacAddress.of((long)1193046L)).setName("abc").setConfig((Set)Sets.immutableEnumSet((Enum)OFPortConfig.PORT_DOWN, (Enum[])new OFPortConfig[0])).setState((Set)Sets.immutableEnumSet((Enum)OFPortState.LINK_DOWN, (Enum[])new OFPortState[0])).setProperties(Arrays.asList(this.factory.buildPortDescPropEthernet().setCurr(1L).setAdvertised(2L).setSupported(4L).setPeer(8L).setCurrSpeed(10L).setMaxSpeed(14L).build())).build());
        OFPortStatus portStatus = builder.build();
        ByteBuf bb = Unpooled.buffer();
        portStatus.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)PORT_STATUS_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFPortStatus.Builder builder = this.factory.buildPortStatus();
        builder.setXid(305419896L).setReason(OFPortReason.ADD).setDesc(this.factory.buildPortDesc().setPortNo(OFPort.ofInt((int)4)).setHwAddr(MacAddress.of((long)1193046L)).setName("abc").setConfig((Set)Sets.immutableEnumSet((Enum)OFPortConfig.PORT_DOWN, (Enum[])new OFPortConfig[0])).setState((Set)Sets.immutableEnumSet((Enum)OFPortState.LINK_DOWN, (Enum[])new OFPortState[0])).setProperties(Arrays.asList(this.factory.buildPortDescPropEthernet().setCurr(1L).setAdvertised(2L).setSupported(4L).setPeer(8L).setCurrSpeed(10L).setMaxSpeed(14L).build())).build());
        OFPortStatus portStatusBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])PORT_STATUS_SERIALIZED);
        OFPortStatus portStatusRead = OFPortStatusVer15.READER.readFrom(input);
        Assert.assertEquals((long)PORT_STATUS_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)portStatusBuilt, (Object)portStatusRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])PORT_STATUS_SERIALIZED);
        OFPortStatus portStatus = OFPortStatusVer15.READER.readFrom(input);
        Assert.assertEquals((long)PORT_STATUS_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        portStatus.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)PORT_STATUS_SERIALIZED));
    }
}

