/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFMeterConfigStatsReply;
import org.projectfloodlight.openflow.protocol.OFMeterFlags;
import org.projectfloodlight.openflow.protocol.OFStatsReplyFlags;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFMeterConfigStatsReplyVer15;

public class OFMeterConfigStatsReplyVer15Test {
    OFFactory factory;
    static final byte[] METER_CONFIG_STATS_REPLY_SERIALIZED = new byte[]{6, 19, 0, 40, 18, 52, 86, 120, 0, 10, 0, 1, 0, 0, 0, 0, 0, 24, 0, 1, 0, 0, 0, 1, 0, 1, 0, 16, 0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFMeterConfigStatsReply.Builder builder = this.factory.buildMeterConfigStatsReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setEntries((List)ImmutableList.of((Object)this.factory.buildMeterConfig().setFlags((Set)ImmutableSet.of((Object)OFMeterFlags.KBPS)).setMeterId(1L).setEntries((List)ImmutableList.of((Object)this.factory.meterBands().buildDrop().setRate(1L).setBurstSize(2L).build())).build())).build();
        OFMeterConfigStatsReply meterConfigStatsReply = builder.build();
        ByteBuf bb = Unpooled.buffer();
        meterConfigStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)METER_CONFIG_STATS_REPLY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFMeterConfigStatsReply.Builder builder = this.factory.buildMeterConfigStatsReply();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsReplyFlags.REPLY_MORE)).setEntries((List)ImmutableList.of((Object)this.factory.buildMeterConfig().setFlags((Set)ImmutableSet.of((Object)OFMeterFlags.KBPS)).setMeterId(1L).setEntries((List)ImmutableList.of((Object)this.factory.meterBands().buildDrop().setRate(1L).setBurstSize(2L).build())).build())).build();
        OFMeterConfigStatsReply meterConfigStatsReplyBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])METER_CONFIG_STATS_REPLY_SERIALIZED);
        OFMeterConfigStatsReply meterConfigStatsReplyRead = OFMeterConfigStatsReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)METER_CONFIG_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)meterConfigStatsReplyBuilt, (Object)meterConfigStatsReplyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])METER_CONFIG_STATS_REPLY_SERIALIZED);
        OFMeterConfigStatsReply meterConfigStatsReply = OFMeterConfigStatsReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)METER_CONFIG_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        meterConfigStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)METER_CONFIG_STATS_REPLY_SERIALIZED));
    }
}

