/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFBundleFeatureFlags;
import org.projectfloodlight.openflow.protocol.OFBundleFeaturesStatsRequest;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.ver15.OFBundleFeaturesStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.types.U64;

public class OFBundleFeaturesStatsRequestVer15Test {
    OFFactory factory;
    static final byte[] BUNDLE_FEATURES_STATS_REQUEST_SERIALIZED = new byte[]{6, 18, 0, 96, 18, 52, 86, 120, 0, 19, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 72, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, -78, -48, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, -78, -48, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, -78, -48, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, -78, -48, 94, 0, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFBundleFeaturesStatsRequest.Builder builder = this.factory.buildBundleFeaturesStatsRequest();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsRequestFlags.REQ_MORE)).setFeatureRequestFlags((Set)ImmutableSet.of((Object)OFBundleFeatureFlags.TIMESTAMP)).setProperties((List)ImmutableList.of((Object)this.factory.buildBundleFeaturesPropTime().setSchedAccuracy(this.factory.buildTime().setSeconds(U64.of((long)3L)).setNanoseconds(3000000000L).build()).setSchedMaxFuture(this.factory.buildTime().setSeconds(U64.of((long)3L)).setNanoseconds(3000000000L).build()).setSchedMaxPast(this.factory.buildTime().setSeconds(U64.of((long)3L)).setNanoseconds(3000000000L).build()).setTimestamp(this.factory.buildTime().setSeconds(U64.of((long)3L)).setNanoseconds(3000000000L).build()).build())).build();
        OFBundleFeaturesStatsRequest bundleFeaturesStatsRequest = builder.build();
        ByteBuf bb = Unpooled.buffer();
        bundleFeaturesStatsRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BUNDLE_FEATURES_STATS_REQUEST_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFBundleFeaturesStatsRequest.Builder builder = this.factory.buildBundleFeaturesStatsRequest();
        builder.setXid(305419896L).setFlags((Set)ImmutableSet.of((Object)OFStatsRequestFlags.REQ_MORE)).setFeatureRequestFlags((Set)ImmutableSet.of((Object)OFBundleFeatureFlags.TIMESTAMP)).setProperties((List)ImmutableList.of((Object)this.factory.buildBundleFeaturesPropTime().setSchedAccuracy(this.factory.buildTime().setSeconds(U64.of((long)3L)).setNanoseconds(3000000000L).build()).setSchedMaxFuture(this.factory.buildTime().setSeconds(U64.of((long)3L)).setNanoseconds(3000000000L).build()).setSchedMaxPast(this.factory.buildTime().setSeconds(U64.of((long)3L)).setNanoseconds(3000000000L).build()).setTimestamp(this.factory.buildTime().setSeconds(U64.of((long)3L)).setNanoseconds(3000000000L).build()).build())).build();
        OFBundleFeaturesStatsRequest bundleFeaturesStatsRequestBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])BUNDLE_FEATURES_STATS_REQUEST_SERIALIZED);
        OFBundleFeaturesStatsRequest bundleFeaturesStatsRequestRead = OFBundleFeaturesStatsRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)BUNDLE_FEATURES_STATS_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)bundleFeaturesStatsRequestBuilt, (Object)bundleFeaturesStatsRequestRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])BUNDLE_FEATURES_STATS_REQUEST_SERIALIZED);
        OFBundleFeaturesStatsRequest bundleFeaturesStatsRequest = OFBundleFeaturesStatsRequestVer15.READER.readFrom(input);
        Assert.assertEquals((long)BUNDLE_FEATURES_STATS_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        bundleFeaturesStatsRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BUNDLE_FEATURES_STATS_REQUEST_SERIALIZED));
    }
}

