/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFAsyncGetReply;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.ver15.OFAsyncGetReplyVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;

public class OFAsyncGetReplyVer15Test {
    OFFactory factory;
    static final byte[] ASYNC_GET_REPLY_SERIALIZED = new byte[]{6, 27, 0, 16, 18, 52, 86, 120, 0, 1, 0, 8, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFAsyncGetReply.Builder builder = this.factory.buildAsyncGetReply();
        builder.setXid(305419896L).setProperties((List)ImmutableList.of((Object)this.factory.buildAsyncConfigPropPacketInMaster().setMask(0L).build())).build();
        OFAsyncGetReply asyncGetReply = builder.build();
        ByteBuf bb = Unpooled.buffer();
        asyncGetReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)ASYNC_GET_REPLY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFAsyncGetReply.Builder builder = this.factory.buildAsyncGetReply();
        builder.setXid(305419896L).setProperties((List)ImmutableList.of((Object)this.factory.buildAsyncConfigPropPacketInMaster().setMask(0L).build())).build();
        OFAsyncGetReply asyncGetReplyBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])ASYNC_GET_REPLY_SERIALIZED);
        OFAsyncGetReply asyncGetReplyRead = OFAsyncGetReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)ASYNC_GET_REPLY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)asyncGetReplyBuilt, (Object)asyncGetReplyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])ASYNC_GET_REPLY_SERIALIZED);
        OFAsyncGetReply asyncGetReply = OFAsyncGetReplyVer15.READER.readFrom(input);
        Assert.assertEquals((long)ASYNC_GET_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        asyncGetReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)ASYNC_GET_REPLY_SERIALIZED));
    }
}

