/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFlowModFailedCode;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.errormsg.OFErrorMsgs;
import org.projectfloodlight.openflow.protocol.errormsg.OFFlowModFailedErrorMsg;
import org.projectfloodlight.openflow.protocol.ver15.OFErrorMsgsVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFlowModFailedErrorMsgVer15;
import org.projectfloodlight.openflow.types.OFErrorCauseData;

public class OFFlowModFailedErrorMsgVer15Test {
    OFErrorMsgs factory;
    static final byte[] FLOW_MOD_FAILED_ERROR_MSG_SERIALIZED = new byte[]{6, 1, 0, 15, 18, 52, 86, 120, 0, 5, 0, 1, 97, 98, 99};

    @Before
    public void setup() {
        this.factory = OFErrorMsgsVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFFlowModFailedErrorMsg.Builder builder = this.factory.buildFlowModFailedErrorMsg();
        builder.setXid(305419896L).setCode(OFFlowModFailedCode.TABLE_FULL).setData(OFErrorCauseData.of((byte[])new byte[]{97, 98, 99}, (OFVersion)OFVersion.OF_15));
        OFFlowModFailedErrorMsg flowModFailedErrorMsg = builder.build();
        ByteBuf bb = Unpooled.buffer();
        flowModFailedErrorMsg.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)FLOW_MOD_FAILED_ERROR_MSG_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFFlowModFailedErrorMsg.Builder builder = this.factory.buildFlowModFailedErrorMsg();
        builder.setXid(305419896L).setCode(OFFlowModFailedCode.TABLE_FULL).setData(OFErrorCauseData.of((byte[])new byte[]{97, 98, 99}, (OFVersion)OFVersion.OF_15));
        OFFlowModFailedErrorMsg flowModFailedErrorMsgBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])FLOW_MOD_FAILED_ERROR_MSG_SERIALIZED);
        OFFlowModFailedErrorMsg flowModFailedErrorMsgRead = OFFlowModFailedErrorMsgVer15.READER.readFrom(input);
        Assert.assertEquals((long)FLOW_MOD_FAILED_ERROR_MSG_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)flowModFailedErrorMsgBuilt, (Object)flowModFailedErrorMsgRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])FLOW_MOD_FAILED_ERROR_MSG_SERIALIZED);
        OFFlowModFailedErrorMsg flowModFailedErrorMsg = OFFlowModFailedErrorMsgVer15.READER.readFrom(input);
        Assert.assertEquals((long)FLOW_MOD_FAILED_ERROR_MSG_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        flowModFailedErrorMsg.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)FLOW_MOD_FAILED_ERROR_MSG_SERIALIZED));
    }
}

