/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFPortConfig;
import org.projectfloodlight.openflow.protocol.OFPortDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFPortState;
import org.projectfloodlight.openflow.protocol.ver14.OFFactoryVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFPortDescStatsReplyVer14;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.OFPort;

public class OFPortDescStatsReplyVer14Test {
    OFFactory factory;
    static final byte[] PORT_DESC_STATS_REPLY_SERIALIZED = new byte[]{5, 19, 0, 88, 0, 0, 0, 5, 0, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 72, 0, 0, 1, 2, 3, 4, 5, 6, 0, 0, 105, 110, 116, 101, 114, 102, 97, 99, 101, 49, 50, 51, 52, 53, 54, 55, 0, 0, 0, 96, 0, 0, 0, 3, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -128};

    @Before
    public void setup() {
        this.factory = OFFactoryVer14.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFPortDescStatsReply.Builder builder = this.factory.buildPortDescStatsReply();
        builder.setXid(5L).setFlags((Set)ImmutableSet.of()).setEntries((List)ImmutableList.of((Object)this.factory.buildPortDesc().setPortNo(OFPort.of((int)1)).setHwAddr(MacAddress.of((String)"01:02:03:04:05:06")).setName("interface1234567").setConfig((Set)Sets.immutableEnumSet((Enum)OFPortConfig.NO_FWD, (Enum[])new OFPortConfig[]{OFPortConfig.NO_PACKET_IN})).setState((Set)Sets.immutableEnumSet((Enum)OFPortState.LINK_DOWN, (Enum[])new OFPortState[]{OFPortState.BLOCKED})).setProperties((List)ImmutableList.of((Object)this.factory.buildPortDescPropEthernet().setCurr(112L).setMaxSpeed(128L).build())).build()));
        OFPortDescStatsReply portDescStatsReply = builder.build();
        ByteBuf bb = Unpooled.buffer();
        portDescStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)PORT_DESC_STATS_REPLY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFPortDescStatsReply.Builder builder = this.factory.buildPortDescStatsReply();
        builder.setXid(5L).setFlags((Set)ImmutableSet.of()).setEntries((List)ImmutableList.of((Object)this.factory.buildPortDesc().setPortNo(OFPort.of((int)1)).setHwAddr(MacAddress.of((String)"01:02:03:04:05:06")).setName("interface1234567").setConfig((Set)Sets.immutableEnumSet((Enum)OFPortConfig.NO_FWD, (Enum[])new OFPortConfig[]{OFPortConfig.NO_PACKET_IN})).setState((Set)Sets.immutableEnumSet((Enum)OFPortState.LINK_DOWN, (Enum[])new OFPortState[]{OFPortState.BLOCKED})).setProperties((List)ImmutableList.of((Object)this.factory.buildPortDescPropEthernet().setCurr(112L).setMaxSpeed(128L).build())).build()));
        OFPortDescStatsReply portDescStatsReplyBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])PORT_DESC_STATS_REPLY_SERIALIZED);
        OFPortDescStatsReply portDescStatsReplyRead = OFPortDescStatsReplyVer14.READER.readFrom(input);
        Assert.assertEquals((long)PORT_DESC_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)portDescStatsReplyBuilt, (Object)portDescStatsReplyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])PORT_DESC_STATS_REPLY_SERIALIZED);
        OFPortDescStatsReply portDescStatsReply = OFPortDescStatsReplyVer14.READER.readFrom(input);
        Assert.assertEquals((long)PORT_DESC_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        portDescStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)PORT_DESC_STATS_REPLY_SERIALIZED));
    }
}

