/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.UnsignedInts;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.types.OFValueType;

public class ArpOpcode
implements OFValueType<ArpOpcode> {
    static final int LENGTH = 2;
    private static final int VAL_REQUEST = 1;
    private static final int VAL_REPLY = 2;
    private static final int VAL_REQUEST_REVERSE = 3;
    private static final int VAL_REPLY_REVERSE = 4;
    private static final int VAL_DRARP_REQUEST = 5;
    private static final int VAL_DRARP_REPLY = 6;
    private static final int VAL_DRARP_ERROR = 7;
    private static final int VAL_INARP_REQUEST = 8;
    private static final int VAL_INARP_REPLY = 9;
    private static final int VAL_ARP_NAK = 10;
    private static final int VAL_MARS_REQUEST = 11;
    private static final int VAL_MARS_MULTI = 12;
    private static final int VAL_MARS_MSERV = 13;
    private static final int VAL_MARS_JOIN = 14;
    private static final int VAL_MARS_LEAVE = 15;
    private static final int VAL_MARS_NAK = 16;
    private static final int VAL_MARS_UNSERV = 17;
    private static final int VAL_MARS_SJOIN = 18;
    private static final int VAL_MARS_SLEAVE = 19;
    private static final int VAL_MARS_GROUPLIST_REQUEST = 20;
    private static final int VAL_MARS_GROUPLIST_REPLY = 21;
    private static final int VAL_MARS_REDIRECT_MAP = 22;
    private static final int VAL_MAPOS_UNARP = 23;
    private static final int VAL_OP_EXP1 = 24;
    private static final int VAL_OP_EXP2 = 25;
    public static final ArpOpcode REQUEST = new ArpOpcode(1);
    public static final ArpOpcode REPLY = new ArpOpcode(2);
    public static final ArpOpcode REQUEST_REVERSE = new ArpOpcode(3);
    public static final ArpOpcode REPLY_REVERSE = new ArpOpcode(4);
    public static final ArpOpcode DRARP_REQUEST = new ArpOpcode(5);
    public static final ArpOpcode DRARP_REPLY = new ArpOpcode(6);
    public static final ArpOpcode DRARP_ERROR = new ArpOpcode(7);
    public static final ArpOpcode INARP_REQUEST = new ArpOpcode(8);
    public static final ArpOpcode INARP_REPLY = new ArpOpcode(9);
    public static final ArpOpcode ARP_NAK = new ArpOpcode(10);
    public static final ArpOpcode MARS_REQUEST = new ArpOpcode(11);
    public static final ArpOpcode MARS_MULTI = new ArpOpcode(12);
    public static final ArpOpcode MARS_MSERV = new ArpOpcode(13);
    public static final ArpOpcode MARS_JOIN = new ArpOpcode(14);
    public static final ArpOpcode MARS_LEAVE = new ArpOpcode(15);
    public static final ArpOpcode MARS_NAK = new ArpOpcode(16);
    public static final ArpOpcode MARS_UNSERV = new ArpOpcode(17);
    public static final ArpOpcode MARS_SJOIN = new ArpOpcode(18);
    public static final ArpOpcode MARS_SLEAVE = new ArpOpcode(19);
    public static final ArpOpcode MARS_GROUPLIST_REQUEST = new ArpOpcode(20);
    public static final ArpOpcode MARS_GROUPLIST_REPLY = new ArpOpcode(21);
    public static final ArpOpcode MARS_REDIRECT_MAP = new ArpOpcode(22);
    public static final ArpOpcode MAPOS_UNARP = new ArpOpcode(23);
    public static final ArpOpcode OP_EXP1 = new ArpOpcode(24);
    public static final ArpOpcode OP_EXP2 = new ArpOpcode(25);
    private static final int MIN_OPCODE = 0;
    private static final int MAX_OPCODE = 65535;
    private static final int NONE_VAL = 0;
    public static final ArpOpcode NONE = new ArpOpcode(0);
    public static final ArpOpcode NO_MASK = new ArpOpcode(-1);
    public static final ArpOpcode FULL_MASK = new ArpOpcode(0);
    private final int opcode;

    private ArpOpcode(int opcode) {
        this.opcode = opcode;
    }

    @Override
    public int getLength() {
        return 2;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public static ArpOpcode of(int opcode) {
        if (opcode < 0 || opcode > 65535) {
            throw new IllegalArgumentException("Invalid ARP opcode: " + opcode);
        }
        switch (opcode) {
            case 0: {
                return NONE;
            }
            case 1: {
                return REQUEST;
            }
            case 2: {
                return REPLY;
            }
            case 3: {
                return REQUEST_REVERSE;
            }
            case 4: {
                return REPLY_REVERSE;
            }
            case 5: {
                return DRARP_REQUEST;
            }
            case 6: {
                return DRARP_REPLY;
            }
            case 7: {
                return DRARP_ERROR;
            }
            case 8: {
                return INARP_REQUEST;
            }
            case 9: {
                return INARP_REPLY;
            }
            case 10: {
                return ARP_NAK;
            }
            case 11: {
                return MARS_REQUEST;
            }
            case 12: {
                return MARS_MULTI;
            }
            case 13: {
                return MARS_MSERV;
            }
            case 14: {
                return MARS_JOIN;
            }
            case 15: {
                return MARS_LEAVE;
            }
            case 16: {
                return MARS_NAK;
            }
            case 17: {
                return MARS_UNSERV;
            }
            case 18: {
                return MARS_SJOIN;
            }
            case 19: {
                return MARS_SLEAVE;
            }
            case 20: {
                return MARS_GROUPLIST_REQUEST;
            }
            case 21: {
                return MARS_GROUPLIST_REPLY;
            }
            case 22: {
                return MARS_REDIRECT_MAP;
            }
            case 23: {
                return MAPOS_UNARP;
            }
            case 24: {
                return OP_EXP1;
            }
            case 25: {
                return OP_EXP2;
            }
        }
        return new ArpOpcode(opcode);
    }

    public void write2Bytes(ByteBuf c) {
        c.writeShort(this.opcode);
    }

    public static ArpOpcode read2Bytes(ByteBuf c) {
        return ArpOpcode.of(c.readUnsignedShort());
    }

    @Override
    public ArpOpcode applyMask(ArpOpcode mask) {
        return ArpOpcode.of(this.opcode & mask.opcode);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.opcode;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArpOpcode other = (ArpOpcode)obj;
        return this.opcode == other.opcode;
    }

    @Override
    public int compareTo(ArpOpcode o) {
        return UnsignedInts.compare((int)this.opcode, (int)o.opcode);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putShort((short)this.opcode);
    }

    public String toString() {
        return String.valueOf(this.opcode);
    }
}

